/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.beacons;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.EntityPositionSyncEvent;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.models.beacons.event.BeaconEvent;
import com.wynntils.models.beacons.event.BeaconMarkerEvent;
import com.wynntils.models.beacons.type.Beacon;
import com.wynntils.models.beacons.type.BeaconKind;
import com.wynntils.models.beacons.type.BeaconMarker;
import com.wynntils.models.beacons.type.BeaconMarkerKind;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.PreciseLocation;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_8113;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class BeaconModel
extends Model {
    private static final Pattern MARKER_DISTANCE_PATTERN = Pattern.compile("\n(\\d+)m (\u00a7[a-z0-9])?(\ue000|\ue001)?");
    private static final Pattern MARKER_COLOR_PATTERN = Pattern.compile("\u00a7((?:#)?([a-z0-9]{1,8}))");
    private static final class_2960 MARKER_FONT = class_2960.method_60656((String)"marker");
    private static final List<BeaconKind> beaconRegistry = new ArrayList<BeaconKind>();
    private static final List<BeaconMarkerKind> beaconMarkerRegistry = new ArrayList<BeaconMarkerKind>();
    private final Map<Integer, Beacon> beacons = new Int2ObjectArrayMap();
    private final Map<Integer, BeaconMarker> beaconMarkers = new Int2ObjectArrayMap();
    public static final String BEACON_COLOR_CUSTOM_MODEL_DATA_KEY = "beacon_color";

    public BeaconModel() {
        super(List.of());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySetData(SetEntityDataEvent event) {
        class_1297 entity = McUtils.mc().field_1687.method_8469(event.getId());
        if (entity instanceof class_8113.class_8122) {
            class_2945.class_7834 dataValue = event.getPackedItems().stream().filter(data -> data.comp_1115() == class_8113.class_8122.field_42423.comp_2327()).findFirst().orElse(null);
            if (dataValue == null) {
                return;
            }
            class_1799 itemStack = (class_1799)dataValue.comp_1117();
            BeaconKind beaconKind = BeaconModel.beaconKindFromItemStack(itemStack);
            if (beaconKind == null) {
                return;
            }
            Beacon<BeaconKind> beacon = new Beacon<BeaconKind>(PreciseLocation.fromVec(entity.method_19538()), beaconKind);
            this.beacons.put(event.getId(), beacon);
            WynntilsMod.postEvent(new BeaconEvent.Added(beacon, entity));
        } else if (entity instanceof class_8113.class_8123) {
            class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
            StyledText styledText = StyledText.fromComponent(textDisplay.method_48915());
            if (styledText.getPartCount() == 0) {
                return;
            }
            if (!styledText.getFirstPart().getPartStyle().getFont().equals((Object)MARKER_FONT)) {
                return;
            }
            BeaconMarkerKind beaconMarkerKind = BeaconModel.beaconMarkerKindFromIcon(styledText);
            if (beaconMarkerKind == null) {
                return;
            }
            Optional<Integer> distanceOpt = BeaconModel.getDistance(styledText);
            Optional<CustomColor> customColorOpt = BeaconModel.getCustomColor(styledText);
            BeaconMarker beaconMarker = new BeaconMarker(entity.method_19538(), beaconMarkerKind, distanceOpt, customColorOpt);
            this.beaconMarkers.put(event.getId(), beaconMarker);
            WynntilsMod.postEvent(new BeaconMarkerEvent.Added(beaconMarker, entity));
        }
    }

    @SubscribeEvent
    public void onEntityPositionSync(EntityPositionSyncEvent event) {
        Beacon movedBeacon = this.beacons.get(event.getEntity().method_5628());
        BeaconMarker movedBeaconMarker = this.beaconMarkers.get(event.getEntity().method_5628());
        if (movedBeacon != null) {
            Beacon newBeacon = new Beacon(PreciseLocation.fromVec(event.getNewPosition()), movedBeacon.beaconKind());
            this.beacons.put(event.getEntity().method_5628(), newBeacon);
            WynntilsMod.postEvent(new BeaconEvent.Moved(movedBeacon, newBeacon));
        } else if (movedBeaconMarker != null) {
            BeaconMarker newBeaconMarker = new BeaconMarker(event.getNewPosition(), movedBeaconMarker.beaconMarkerKind(), movedBeaconMarker.distance(), movedBeaconMarker.color());
            this.beaconMarkers.put(event.getEntity().method_5628(), newBeaconMarker);
            WynntilsMod.postEvent(new BeaconMarkerEvent.Moved(movedBeaconMarker, newBeaconMarker));
        }
    }

    @SubscribeEvent
    public void onEntityRemoved(RemoveEntitiesEvent event) {
        event.getEntityIds().stream().filter(this.beacons::containsKey).forEach(entityId -> {
            Beacon removedBeacon = this.beacons.get(entityId);
            this.beacons.remove(entityId);
            WynntilsMod.postEvent(new BeaconEvent.Removed(removedBeacon));
        });
        event.getEntityIds().stream().filter(this.beaconMarkers::containsKey).forEach(entityId -> {
            BeaconMarker removedBeaconMarker = this.beaconMarkers.get(entityId);
            this.beaconMarkers.remove(entityId);
            WynntilsMod.postEvent(new BeaconMarkerEvent.Removed(removedBeaconMarker));
        });
    }

    public void registerBeacon(BeaconKind beaconKind) {
        beaconRegistry.add(beaconKind);
    }

    public void registerBeaconMarker(BeaconMarkerKind beaconMarkerKind) {
        beaconMarkerRegistry.add(beaconMarkerKind);
    }

    private static BeaconKind beaconKindFromItemStack(class_1799 itemStack) {
        for (BeaconKind beaconKind : beaconRegistry) {
            if (!beaconKind.matches(itemStack)) continue;
            return beaconKind;
        }
        if (WynntilsMod.isDevelopmentEnvironment()) {
            if (itemStack.method_7909() != class_1802.field_8574) {
                return null;
            }
            Optional<Float> beaconColorCustomModelData = Services.CustomModel.getFloat(BEACON_COLOR_CUSTOM_MODEL_DATA_KEY);
            if (beaconColorCustomModelData.isEmpty()) {
                return null;
            }
            class_1844 potionContents = (class_1844)itemStack.method_57824(class_9334.field_49651);
            if (potionContents == null) {
                return null;
            }
            class_9280 customModelData = (class_9280)itemStack.method_57824(class_9334.field_49637);
            if (customModelData == null) {
                return null;
            }
            List<Float> customModelValues = customModelData.comp_3354().stream().filter(value -> beaconRegistry.stream().map(BeaconKind::getCustomModelData).anyMatch(value::equals)).toList();
            if (customModelValues.isEmpty()) {
                return null;
            }
            int customColor = potionContents.comp_2379().orElse(CommonColors.WHITE.asInt());
            if (customModelValues.stream().anyMatch(beaconColorCustomModelData.get()::equals)) {
                WynntilsMod.warn("Unknown beacon kind: " + String.valueOf(beaconColorCustomModelData.get()) + " " + customColor);
            }
        }
        return null;
    }

    private static BeaconMarkerKind beaconMarkerKindFromIcon(StyledText iconStyledText) {
        for (BeaconMarkerKind beaconMarkerKind : beaconMarkerRegistry) {
            if (!beaconMarkerKind.matches(iconStyledText)) continue;
            return beaconMarkerKind;
        }
        return null;
    }

    private static Optional<Integer> getDistance(StyledText styledText) {
        Optional<Integer> distanceOpt = Optional.empty();
        Matcher distanceMatcher = styledText.getMatcher(MARKER_DISTANCE_PATTERN);
        if (distanceMatcher.find()) {
            distanceOpt = Optional.of(Integer.parseInt(distanceMatcher.group(1)));
        }
        return distanceOpt;
    }

    private static Optional<CustomColor> getCustomColor(StyledText styledText) {
        Optional<CustomColor> colorOpt = Optional.empty();
        Matcher colorMatcher = styledText.getMatcher(MARKER_COLOR_PATTERN);
        if (colorMatcher.find()) {
            String colorStr = colorMatcher.group(1);
            colorOpt = colorStr.startsWith("#") ? Optional.of(CustomColor.fromHexString(colorMatcher.group(1))) : Optional.of(CustomColor.fromChatFormatting(class_124.method_544((char)colorStr.charAt(0))));
        }
        return colorOpt;
    }
}

