/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear.type;

import com.wynntils.core.components.Services;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public enum GearType {
    SPEAR(ClassType.WARRIOR, "spear", class_1802.field_8699, 0),
    WAND(ClassType.MAGE, "wand", class_1802.field_8876, 1),
    DAGGER(ClassType.ASSASSIN, "dagger", class_1802.field_8868, 2),
    BOW(ClassType.ARCHER, "bow", class_1802.field_8102, 3),
    RELIK(ClassType.SHAMAN, "relik", class_1802.field_8776, 4),
    WEAPON(null, null, 12),
    ACCESSORY(null, null, 13),
    RING(null, "ring", 5),
    BRACELET(null, "bracelet", 6),
    NECKLACE(null, "necklace", 7),
    HELMET(null, class_1802.field_8267, "helmet", "helmet_skin", List.of(class_1802.field_8267, class_1802.field_8283, class_1802.field_8743, class_1802.field_8862, class_1802.field_8805, class_1802.field_22027, class_1802.field_8574), 8),
    CHESTPLATE(null, class_1802.field_8577, "chestplate", List.of(class_1802.field_8873, class_1802.field_8523, class_1802.field_8678, class_1802.field_8058, class_1802.field_22028), 9),
    LEGGINGS(null, class_1802.field_8570, "leggings", List.of(class_1802.field_8218, class_1802.field_8396, class_1802.field_8416, class_1802.field_8348, class_1802.field_22029), 10),
    BOOTS(null, class_1802.field_8370, "boots", List.of(class_1802.field_8313, class_1802.field_8660, class_1802.field_8753, class_1802.field_8285, class_1802.field_22030), 11),
    MASTERY_TOME(null, "tome", -1),
    CHARM(null, "charm", -1);

    private final ClassType classReq;
    private final class_1792 defaultItem;
    private final String modelKey;
    private final String skinModelKey;
    private final List<class_1792> otherItems;
    private final int encodingId;
    private List<Float> modelList = new ArrayList<Float>();
    private static final Map<Integer, GearType> craftedAccessoryMap;

    private GearType(ClassType classReq, class_1792 defaultItem, String modelKey, String skinModelKey, List<class_1792> otherItems, int encodingId) {
        this.classReq = classReq;
        this.defaultItem = defaultItem;
        this.modelKey = modelKey;
        this.skinModelKey = skinModelKey;
        this.otherItems = otherItems;
        this.encodingId = encodingId;
    }

    private GearType(ClassType classReq, class_1792 defaultItem, String modelKey, List<class_1792> otherItems, int encodingId) {
        this(classReq, defaultItem, modelKey, null, otherItems, encodingId);
    }

    private GearType(ClassType classReq, String modelKey, class_1792 craftedItem, int encodingId) {
        this(classReq, class_1802.field_8574, modelKey, List.of(craftedItem), encodingId);
    }

    private GearType(ClassType classReq, String modelKey, int encodingId) {
        this(classReq, class_1802.field_8574, modelKey, List.of(), encodingId);
    }

    public static GearType fromString(String typeStr) {
        try {
            return GearType.valueOf(typeStr.toUpperCase(Locale.ROOT).replace(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static GearType fromItemStack(class_1799 itemStack, boolean crafted) {
        class_1792 item = itemStack.method_7909();
        class_9280 customModelData = (class_9280)itemStack.method_57824(class_9334.field_49637);
        if (customModelData != null && !customModelData.comp_3354().isEmpty()) {
            for (GearType gearType : GearType.values()) {
                if (gearType.isReward()) continue;
                List customModelDataValue = customModelData.comp_3354();
                for (Float modelValue : customModelDataValue) {
                    if (!gearType.defaultItem.equals(item) && !gearType.otherItems.contains(item) || !gearType.getModelList().contains(modelValue)) continue;
                    return gearType;
                }
            }
        } else if (crafted) {
            for (GearType gearType : GearType.values()) {
                if ((!gearType.isArmor() || !gearType.defaultItem.equals(item) && !gearType.otherItems.contains(item)) && (!gearType.isWeapon() || !gearType.otherItems.contains(item))) continue;
                return gearType;
            }
            if (item == class_1802.field_8884) {
                int damage = itemStack.method_7919();
                return craftedAccessoryMap.getOrDefault(damage, null);
            }
        }
        return null;
    }

    public static GearType fromClassType(ClassType classType) {
        for (GearType gearType : GearType.values()) {
            if (gearType.classReq != classType) continue;
            return gearType;
        }
        return null;
    }

    public static GearType fromEncodingId(int id) {
        for (GearType gearType : GearType.values()) {
            if (gearType.encodingId != id) continue;
            return gearType;
        }
        return null;
    }

    public ClassType getClassReq() {
        return this.classReq;
    }

    public class_1792 getDefaultItem() {
        return this.defaultItem;
    }

    public float getDefaultModel() {
        if (Services.CustomModel.getRange(this.modelKey).isPresent()) {
            return Services.CustomModel.getRange(this.modelKey).get().a().floatValue();
        }
        return -1.0f;
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public boolean isReward() {
        return this == MASTERY_TOME || this == CHARM;
    }

    public boolean isWeapon() {
        return this.classReq != null || this == WEAPON;
    }

    public boolean isAccessory() {
        return this.defaultItem == class_1802.field_8884 || this.defaultItem == class_1802.field_8574;
    }

    public boolean isArmor() {
        return switch (this.ordinal()) {
            case 10, 11, 12, 13 -> true;
            default -> false;
        };
    }

    public boolean isValidWeapon(ClassType classType) {
        if (!this.isWeapon()) {
            return false;
        }
        if (this == WEAPON) {
            return true;
        }
        return this.classReq == classType;
    }

    private List<Float> getModelList() {
        if (this.modelList.isEmpty()) {
            ArrayList<Float> tempModelList = new ArrayList<Float>();
            GearType.addRangeToList(Services.CustomModel.getRange(this.modelKey), tempModelList);
            GearType.addRangeToList(Services.CustomModel.getRange(this.skinModelKey), tempModelList);
            this.modelList = List.copyOf(tempModelList);
        }
        return this.modelList;
    }

    private static void addRangeToList(Optional<Pair<Float, Float>> modelRange, List<Float> out) {
        modelRange.ifPresent(range -> {
            int min = ((Float)range.a()).intValue();
            int max = ((Float)range.b()).intValue();
            IntStream.rangeClosed(min, max).mapToObj(i -> Float.valueOf(i)).forEach(out::add);
        });
    }

    private static Map<Integer, GearType> buildCraftedAccessoryMap() {
        HashMap map = new HashMap();
        IntStream.rangeClosed(1, 17).forEach(i -> map.put(i, RING));
        IntStream.rangeClosed(18, 34).forEach(i -> map.put(i, NECKLACE));
        IntStream.rangeClosed(35, 49).forEach(i -> map.put(i, BRACELET));
        return Map.copyOf(map);
    }

    static {
        craftedAccessoryMap = GearType.buildCraftedAccessoryMap();
    }
}

