/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.inventory.type;

import java.util.Locale;

public enum InventoryArmor {
    HELMET("Helmet", 3, 39),
    CHESTPLATE("Chestplate", 2, 38),
    LEGGINGS("Leggings", 1, 37),
    BOOTS("Boots", 0, 36);

    private final String armorName;
    private final int armorSlot;
    private final int inventorySlot;

    private InventoryArmor(String armorName, int armorSlot, int inventorySlot) {
        this.armorName = armorName;
        this.armorSlot = armorSlot;
        this.inventorySlot = inventorySlot;
    }

    public int getArmorSlot() {
        return this.armorSlot;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public static InventoryArmor fromString(String type) {
        try {
            return InventoryArmor.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static int[] getArmorSlots() {
        int[] slots = new int[InventoryArmor.values().length];
        for (int i = 0; i < InventoryArmor.values().length; ++i) {
            slots[i] = InventoryArmor.values()[i].getArmorSlot();
        }
        return slots;
    }
}

