/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public final class EmeraldPouchAnnotator
implements GameItemAnnotator {
    private static final Pattern EMERALD_POUCH_PATTERN = Pattern.compile("^\u00a7aEmerald Pouch \u00a72\\[Tier (\\d+)\\]$");
    private static final Pattern EMERALD_POUCH_LORE_PATTERN = Pattern.compile("\u00a76\u00a7l([\\d\\s,]+)" + EmeraldUnits.EMERALD.getSymbol() + ".*");
    private static final Pattern NUMBER_FORMAT_PATTERN = Pattern.compile("[\\s,]");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        if (itemStack.method_7909() != class_1802.field_8556 && itemStack.method_7909() != class_1802.field_8322) {
            return null;
        }
        Matcher matcher = name.getMatcher(EMERALD_POUCH_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        int tier = Integer.parseInt(matcher.group(1));
        Matcher amountMatcher = LoreUtils.matchLoreLine(itemStack, 0, EMERALD_POUCH_LORE_PATTERN);
        if (!amountMatcher.matches()) {
            return new EmeraldPouchItem(tier, 0);
        }
        int amount = Integer.parseInt(NUMBER_FORMAT_PATTERN.matcher(amountMatcher.group(1)).replaceAll(""));
        return new EmeraldPouchItem(tier, amount);
    }
}

