/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.items.items.game.IngredientItem;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class IngredientAnnotator
implements GameItemAnnotator {
    private static final Pattern INGREDIENT_PATTERN = Pattern.compile("^\u00a77(.+?) (?:\u00a7[3567])?\\[\u00a7([8bde])\u272b(\u00a78)?\u272b(\u00a78)?\u272b\u00a7[3567]\\]$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = name.getMatcher(INGREDIENT_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        String ingredientName = matcher.group(1);
        String tierColor = matcher.group(2);
        int tier = Models.Ingredient.getTierFromColorCode(tierColor);
        IngredientInfo ingredientInfo = Models.Ingredient.getIngredientInfoFromName(ingredientName);
        if (ingredientInfo == null && (ingredientInfo = Models.Ingredient.getIngredientInfoFromApiName(ingredientName)) == null) {
            return null;
        }
        if (ingredientInfo.tier() != tier) {
            WynntilsMod.warn("Incorrect tier in ingredient database: " + ingredientName + " is currently " + tier + " vs API " + ingredientInfo.tier());
        }
        return new IngredientItem(ingredientInfo);
    }
}

