/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.profession.type.MaterialProfile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class MaterialAnnotator
implements GameItemAnnotator {
    private static final Pattern MATERIAL_PATTERN = Pattern.compile("^\u00a7f(.*) ([^ ]+)\u00a76 \\[\u00a7e\u272b((?:\u00a78)?\u272b(?:\u00a78)?)\u272b\u00a76\\]$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        String tierIndicator;
        String resourceType;
        Matcher matcher = name.getMatcher(MATERIAL_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        String materialSource = matcher.group(1);
        MaterialProfile materialProfile = MaterialProfile.lookup(materialSource, resourceType = matcher.group(2), tierIndicator = matcher.group(3));
        if (materialProfile == null) {
            return null;
        }
        return new MaterialItem(materialProfile);
    }
}

