/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.StoreItem;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public final class StoreTierAnnotator
implements GuiItemAnnotator {
    private static final Pattern TIER_PATTERN = Pattern.compile("store_tier_(.+)");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        class_9280 customModelData = (class_9280)itemStack.method_57824(class_9334.field_49637);
        if (customModelData == null) {
            return null;
        }
        List strings = customModelData.comp_3356();
        if (strings.isEmpty()) {
            return null;
        }
        String tierName = strings.stream().map(TIER_PATTERN::matcher).filter(Matcher::matches).map(m -> m.group(1)).findFirst().orElse(null);
        if (tierName == null) {
            return null;
        }
        StoreTier tier = StoreTier.parseTier(tierName);
        if (tier == null) {
            WynntilsMod.warn("Unknown store tier: " + tierName);
        }
        return new StoreItem(tier == null ? CommonColors.WHITE : tier.getHighlightColor());
    }

    private static enum StoreTier {
        BLACK_MARKET(CustomColor.fromInt(0x640404)),
        GODLY(CustomColor.fromInt(15412525)),
        EPIC(CustomColor.fromInt(0xFFBB00)),
        RARE(CustomColor.fromInt(0xDD55FF)),
        COMMON(CustomColor.fromInt(0xFFFDDD));

        private final CustomColor highlightColor;

        private StoreTier(CustomColor highlightColor) {
            this.highlightColor = highlightColor;
        }

        public static StoreTier parseTier(String tierName) {
            for (StoreTier tier : StoreTier.values()) {
                if (!tier.name().equalsIgnoreCase(tierName)) continue;
                return tier;
            }
            return null;
        }

        public CustomColor getHighlightColor() {
            return this.highlightColor;
        }
    }
}

