/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.data;

import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.RangedValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record IdentificationData(List<StatActualValue> identifications, Map<StatType, StatPossibleValues> possibleValues, boolean extendedEncoding, Map<StatType, Integer> pendingCalculations) implements ItemData
{
    public static IdentificationData from(IdentifiableItemProperty<?, ?> property, boolean extendedEncoding) {
        return new IdentificationData(property.getIdentifications(), property.getPossibleValues().stream().collect(HashMap::new, (map, value) -> map.put(value.statType(), value), HashMap::putAll), extendedEncoding, Map.of());
    }

    public ErrorOr<Void> processPendingCalculations(Map<StatType, StatPossibleValues> possibleValuesMap) {
        for (Map.Entry<StatType, Integer> entry : this.pendingCalculations.entrySet()) {
            StatType statType = entry.getKey();
            int internalRoll = entry.getValue();
            StatPossibleValues possibleValues = possibleValuesMap.get(statType);
            if (possibleValues == null) {
                return ErrorOr.error("No possible values for stat type: " + String.valueOf(statType));
            }
            int stars = StatCalculator.calculateStarsFromInternalRoll(statType, possibleValues.baseValue(), internalRoll);
            int value = StatCalculator.calculateStatValue(internalRoll, possibleValues);
            this.identifications.add(new StatActualValue(statType, value, stars, RangedValue.of(internalRoll, internalRoll)));
        }
        this.pendingCalculations.clear();
        return ErrorOr.of(null);
    }
}

