/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.items.encoding.data.EffectsData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.wynnitem.type.ConsumableEffect;
import com.wynntils.models.wynnitem.type.NamedItemEffect;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;

public class EffectsDataTransformer
extends DataTransformer<EffectsData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, EffectsData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeEffectsData(data);
    }

    @Override
    public ErrorOr<EffectsData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeEffectsData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.EFFECTS_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeEffectsData(EffectsData data) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        bytes.add(UnsignedByte.of((byte)data.namedEffects().size()));
        for (NamedItemEffect namedEffect : data.namedEffects()) {
            UnsignedByte id = UnsignedByte.of((byte)namedEffect.type().getId());
            bytes.add(id);
            UnsignedByte[] unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(namedEffect.value());
            bytes.addAll(List.of(unsignedBytes));
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<EffectsData> decodeEffectsData(ArrayReader<UnsignedByte> byteReader) {
        ArrayList<NamedItemEffect> namedEffects = new ArrayList<NamedItemEffect>();
        int numberOfEffects = byteReader.read().value();
        for (int i = 0; i < numberOfEffects; ++i) {
            short effectId = byteReader.read().value();
            ConsumableEffect consumableEffect = ConsumableEffect.fromId(effectId);
            if (consumableEffect == null) {
                return ErrorOr.error("Cannot decode consumable effect: " + effectId);
            }
            int value = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            NamedItemEffect namedEffect = new NamedItemEffect(consumableEffect, value);
            namedEffects.add(namedEffect);
        }
        return ErrorOr.of(new EffectsData(namedEffects));
    }
}

