/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.items.encoding.data.RequirementsData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RequirementsDataTransformer
extends DataTransformer<RequirementsData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, RequirementsData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeRequirementsData(data);
    }

    @Override
    public ErrorOr<RequirementsData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeRequirementsData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.REQUIREMENTS_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodeRequirementsData(RequirementsData data) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        int level = data.requirements().level();
        if (level > 255 || level < 0) {
            return ErrorOr.error("Level requirement does not fit in a byte.");
        }
        bytes.add(UnsignedByte.of((byte)level));
        byte classId = 0;
        if (data.requirements().classType().isPresent()) {
            for (ClassType classType : ClassType.values()) {
                if (classType != data.requirements().classType().get()) continue;
                classId = (byte)classType.getEncodingId();
                break;
            }
        }
        bytes.add(UnsignedByte.of(classId));
        bytes.add(UnsignedByte.of((byte)data.requirements().skills().size()));
        for (Pair pair : data.requirements().skills()) {
            int id = ((Skill)((Object)pair.a())).getAssociatedElement().getEncodingId();
            bytes.add(UnsignedByte.of((byte)id));
            int skillRequirement = (Integer)pair.b();
            UnsignedByte[] encodedRequirement = UnsignedByteUtils.encodeVariableSizedInteger(skillRequirement);
            bytes.addAll(List.of(encodedRequirement));
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<RequirementsData> decodeRequirementsData(ArrayReader<UnsignedByte> byteReader) {
        short level = byteReader.read().value();
        byte classId = byteReader.read().toByte();
        ClassType decodedClassType = ClassType.NONE;
        for (ClassType classType : ClassType.values()) {
            if (classType.getEncodingId() != classId) continue;
            decodedClassType = classType;
            break;
        }
        decodedClassType = decodedClassType == ClassType.NONE ? null : decodedClassType;
        int skillCount = byteReader.read().value();
        ArrayList<Pair<Skill, Integer>> skills = new ArrayList<Pair<Skill, Integer>>();
        for (int i = 0; i < skillCount; ++i) {
            short id = byteReader.read().value();
            Skill skill = Skill.fromElement(Element.fromEncodingId(id));
            if (skill == null) {
                return ErrorOr.error("Invalid skill encoding: " + id);
            }
            int requirement = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            skills.add(Pair.of(skill, requirement));
        }
        return ErrorOr.of(new RequirementsData(new GearRequirements(level, Optional.ofNullable(decodedClassType), skills, Optional.empty())));
    }
}

