/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.npcdialogue.event;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.npcdialogue.type.NpcDialogue;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.neoforged.bus.api.Event;

public abstract class NpcDialogueProcessingEvent
extends Event {

    public static class Post
    extends NpcDialogueProcessingEvent {
        private final NpcDialogue dialogue;
        private final List<StyledText> postProcessedDialogue;
        private final List<class_2561> postProcessedDialogueComponent;

        public Post(NpcDialogue dialogue, List<StyledText> postProcessedDialogue) {
            this.dialogue = dialogue;
            this.postProcessedDialogue = postProcessedDialogue;
            this.postProcessedDialogueComponent = postProcessedDialogue.stream().map(StyledText::getComponent).map(c -> c).toList();
        }

        public NpcDialogue getDialogue() {
            return this.dialogue;
        }

        public List<StyledText> getPostProcessedDialogue() {
            return this.postProcessedDialogue;
        }

        public List<class_2561> getPostProcessedDialogueComponent() {
            return this.postProcessedDialogueComponent;
        }
    }

    public static class Pre
    extends NpcDialogueProcessingEvent {
        private final NpcDialogue dialogue;
        private CompletableFuture<List<StyledText>> postProcessedDialogueFuture;

        public Pre(NpcDialogue dialogue) {
            this.dialogue = dialogue;
            this.postProcessedDialogueFuture = CompletableFuture.completedFuture(dialogue.currentDialogue());
        }

        public void addProcessingStep(Function<CompletableFuture<List<StyledText>>, CompletableFuture<List<StyledText>>> processingStep) {
            this.postProcessedDialogueFuture = processingStep.apply(this.postProcessedDialogueFuture);
        }

        public NpcDialogue getDialogue() {
            return this.dialogue;
        }
    }
}

