/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players.event;

import net.neoforged.bus.api.Event;

public abstract class PartyEvent
extends Event {

    public static class Promoted
    extends PartyEvent {
        private final String oldLeader;
        private final String newLeader;

        public Promoted(String oldLeader, String newLeader) {
            this.oldLeader = oldLeader;
            this.newLeader = newLeader;
        }

        public String getOldLeader() {
            return this.oldLeader;
        }

        public String getNewLeader() {
            return this.newLeader;
        }
    }

    public static class PriorityChanged
    extends PartyEvent {
        private final String playerName;
        private final int priority;

        public PriorityChanged(String playerName, int priority) {
            this.playerName = playerName;
            this.priority = priority;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static class OtherReconnected
    extends PartyEvent {
        private final String playerName;

        public OtherReconnected(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class OtherDisconnected
    extends PartyEvent {
        private final String playerName;

        public OtherDisconnected(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class OtherLeft
    extends PartyEvent {
        private final String playerName;

        public OtherLeft(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class OtherJoined
    extends PartyEvent {
        private final String playerName;

        public OtherJoined(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class Invited
    extends PartyEvent {
        private final String playerName;

        public Invited(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }
    }

    public static class Listed
    extends PartyEvent {
    }
}

