/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession.label;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.profession.label.ProfessionCraftingStationLabelInfo;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.utils.mc.type.Location;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;

public class CraftingStationLabelParser
implements LabelParser<ProfessionCraftingStationLabelInfo> {
    private static final Pattern CRAFTING_STATION_LABEL_PATTERN = Pattern.compile("^\u00a7f[\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd] \u00a76\u00a7l(.+)\u00a7f [\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd]");

    @Override
    public ProfessionCraftingStationLabelInfo getInfo(StyledText label, Location location, class_1297 entity) {
        Matcher matcher = label.getMatcher(CRAFTING_STATION_LABEL_PATTERN);
        if (matcher.find()) {
            ProfessionType professionType = ProfessionType.fromString(matcher.group(1));
            if (professionType == null) {
                return null;
            }
            return new ProfessionCraftingStationLabelInfo(label, matcher.group(1) + " Station", location.offset(0, -2, 0), entity, professionType);
        }
        return null;
    }
}

