/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.spells.type;

import com.wynntils.utils.mc.MouseUtils;
import java.util.Arrays;

public enum SpellDirection {
    RIGHT("\ue101", "\ue104", MouseUtils::sendRightClickInput),
    LEFT("\ue100", "\ue103", MouseUtils::sendLeftClickInput);

    private final String fullIcon;
    private final String smallIcon;
    private final Runnable sendPacketRunnable;
    public static final SpellDirection[] NO_SPELL;

    private SpellDirection(String fullIcon, String smallIcon, Runnable sendPacketRunnable) {
        this.fullIcon = fullIcon;
        this.smallIcon = smallIcon;
        this.sendPacketRunnable = sendPacketRunnable;
    }

    public String getFullIcon() {
        return this.fullIcon;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public Runnable getSendPacketRunnable() {
        return this.sendPacketRunnable;
    }

    public static SpellDirection[] invertArray(SpellDirection[] initial) {
        return (SpellDirection[])Arrays.stream(initial).map(x -> x == RIGHT ? LEFT : RIGHT).toArray(SpellDirection[]::new);
    }

    static {
        NO_SPELL = new SpellDirection[0];
    }
}

