/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.war.type;

import com.wynntils.models.war.type.WarTowerState;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WarBattleInfo {
    private final String territory;
    private final String ownerGuild;
    private final List<WarTowerState> states = new ArrayList<WarTowerState>();

    public WarBattleInfo(String territory, String ownerGuild, WarTowerState initialState) {
        this.territory = territory;
        this.ownerGuild = ownerGuild;
        this.states.add(initialState);
    }

    public String getTerritory() {
        return this.territory;
    }

    public String getOwnerGuild() {
        return this.ownerGuild;
    }

    public WarTowerState getInitialState() {
        return this.states.getFirst();
    }

    public WarTowerState getCurrentState() {
        return this.states.getLast();
    }

    public long getTotalLengthSeconds() {
        return (long)Math.ceil((double)(this.states.getLast().timestamp() - this.states.getFirst().timestamp()) / 1000.0);
    }

    public long getDps(long seconds) {
        if (seconds == Long.MAX_VALUE) {
            WarTowerState initialState = this.getInitialState();
            WarTowerState currentState = this.getCurrentState();
            return (long)Math.floor((double)(initialState.effectiveHealth() - currentState.effectiveHealth()) / ((double)(currentState.timestamp() - initialState.timestamp()) / 1000.0));
        }
        long now = System.currentTimeMillis();
        long start = now - TimeUnit.SECONDS.toMillis(seconds);
        WarTowerState firstRelevantState = null;
        WarTowerState lastRelevantState = null;
        for (WarTowerState state : this.states) {
            if (state.timestamp() < start) continue;
            if (firstRelevantState == null) {
                firstRelevantState = state;
            }
            lastRelevantState = state;
        }
        return firstRelevantState == null || lastRelevantState == null ? 0L : (long)Math.floor((firstRelevantState.effectiveHealth() - lastRelevantState.effectiveHealth()) / seconds);
    }

    public long getTowerEffectiveHp() {
        WarTowerState currentState = this.getCurrentState();
        return currentState.effectiveHealth();
    }

    public RangedValue getTowerDps() {
        WarTowerState currentState = this.getCurrentState();
        return RangedValue.of((int)((double)currentState.damage().low() * currentState.attackSpeed()), (int)((double)currentState.damage().high() * currentState.attackSpeed() * 2.0));
    }

    public long getEstimatedTimeRemaining() {
        WarTowerState currentState = this.getCurrentState();
        long effectiveHp = this.getTowerEffectiveHp();
        long dps = this.getDps(Long.MAX_VALUE);
        return dps == 0L ? -1L : effectiveHp / dps;
    }

    public void addNewState(WarTowerState towerState) {
        this.states.add(towerState);
    }
}

