/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds.type;

import com.wynntils.core.components.Models;
import com.wynntils.models.worlds.type.BombType;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;

public record BombInfo(String user, BombType bomb, String server, long startTime, float length) {
    public String getRemainingString() {
        long millis = this.getRemainingLong();
        return String.format("%02dm %02ds", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }

    public long getRemainingLong() {
        return this.startTime + this.getLength() - System.currentTimeMillis();
    }

    public long endTime() {
        return this.startTime + this.getLength();
    }

    public String asString() {
        return String.valueOf(class_124.field_1065) + this.bomb.getDisplayName() + String.valueOf(class_124.field_1080) + " on " + String.valueOf(this.server.equals(Models.WorldState.getCurrentWorldName()) ? class_124.field_1060 : class_124.field_1068) + this.server + String.valueOf(class_124.field_1065) + " (" + this.getRemainingString() + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.bomb, this.server});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BombInfo)) {
            return false;
        }
        BombInfo bombInfo = (BombInfo)o;
        return Objects.equals(this.user, bombInfo.user) && this.bomb == bombInfo.bomb && Objects.equals(this.server, bombInfo.server);
    }

    public boolean isActive() {
        return System.currentTimeMillis() < this.startTime + this.getLength();
    }

    private long getLength() {
        return (long)(this.length * 60000.0f);
    }
}

