/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.event.ItemRenamedEvent;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.wynn.ItemUtils;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import net.neoforged.bus.api.SubscribeEvent;

public class SpellCastMessageOverlay
extends Overlay {
    private static final int SPELL_MESSAGE_TICKS = 40;
    private StyledText spellMessage;
    private int spellMessageTimer;

    public SpellCastMessageOverlay() {
        super(new OverlayPosition(-100.0f, 0.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(200.0f, 20.0f), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    }

    @SubscribeEvent
    public void onItemRename(ItemRenamedEvent event) {
        if (!ItemUtils.isWeapon(event.getItemStack())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onSpellCast(SpellEvent.Cast event) {
        int manaCost = event.getManaCost();
        int healthCost = event.getHealthCost();
        this.spellMessage = healthCost > 0 ? StyledText.fromString("\u00a77" + event.getSpellType().getName() + " spell cast! \u00a73[\u00a7b-" + manaCost + " \u273a\u00a73] \u00a74[\u00a7c-" + healthCost + " \u2764\u00a74]") : StyledText.fromString("\u00a77" + event.getSpellType().getName() + " spell cast! \u00a73[\u00a7b-" + manaCost + " \u273a\u00a73]");
        this.spellMessageTimer = 40;
    }

    @SubscribeEvent
    public void onSpellFailed(SpellEvent.Failed event) {
        this.spellMessage = event.getFailureReason().getMessage();
        this.spellMessageTimer = 40;
    }

    @Override
    public void tick() {
        if (this.spellMessageTimer <= 0) {
            return;
        }
        --this.spellMessageTimer;
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        if (this.spellMessageTimer <= 0) {
            return;
        }
        int alpha = (int)Math.min((float)this.spellMessageTimer * 256.0f / 10.0f, 255.0f);
        if (alpha <= 0) {
            return;
        }
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), bufferSource, this.spellMessage, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), this.getWidth(), CommonColors.WHITE.withAlpha(alpha), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), TextShadow.NORMAL);
    }
}

