/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.models.spells.type.SpellDirection;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_9779;
import net.neoforged.bus.api.SubscribeEvent;

public class SpellInputsOverlay
extends Overlay {
    private static final int SMALL_CHARACTERS_LEVEL = 11;
    private static final class_2960 SPELL_INPUTS_FONT = class_2960.method_60656((String)"hud/gameplay/default/bottom_middle");
    private static final String FULL_NO_CLICK_CHARACTER = "\ue102";
    private static final String SMALL_NO_CLICK_CHARACTER = "\ue105";
    private static final String SEPARATOR_CHARACTER = "\ue106";
    @Persisted
    private final Config<Boolean> shouldDisplayOriginal = new Config<Boolean>(false);
    @Persisted
    private final Config<SpellInputStyle> inputStyle = new Config<SpellInputStyle>(SpellInputStyle.ORIGINAL);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.NONE);
    @Persisted
    protected final Config<Float> fontScale = new Config<Float>(Float.valueOf(1.0f));
    private StyledText spellText = StyledText.EMPTY;

    public SpellInputsOverlay() {
        super(new OverlayPosition(-62.0f, 0.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(100.0f, 20.0f), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    }

    @SubscribeEvent
    public void onSpellCast(SpellEvent.Partial event) {
        SpellDirection[] dirs = event.getSpellDirectionArray();
        SpellInputStyle style = (SpellInputStyle)((Object)this.inputStyle.get());
        this.spellText = switch (style.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> this.buildUnicodeInputs(dirs, true);
            case 1 -> this.buildUnicodeInputs(dirs, false);
            case 0 -> this.buildUnicodeInputs(dirs, Models.CharacterStats.getLevel() >= 11);
            case 3 -> this.buildLegacyInputs(dirs);
        };
    }

    @SubscribeEvent
    public void onSpellExpired(SpellEvent.Expired event) {
        this.spellText = StyledText.EMPTY;
    }

    @SubscribeEvent
    public void onWorldStateChanged(WorldStateEvent event) {
        this.spellText = StyledText.EMPTY;
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        Models.Spell.setHideSpellInputs(Managers.Overlay.isEnabled(this) && (Boolean)this.shouldDisplayOriginal.get() == false);
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        if (this.spellText.isEmpty()) {
            return;
        }
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), bufferSource, this.spellText, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), this.getWidth(), CommonColors.WHITE, this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), (TextShadow)this.textShadow.get(), ((Float)this.fontScale.get()).floatValue());
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), bufferSource, this.buildUnicodeInputs(new SpellDirection[]{SpellDirection.LEFT, SpellDirection.RIGHT}, true), this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), this.getWidth(), CommonColors.WHITE, this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), (TextShadow)this.textShadow.get(), ((Float)this.fontScale.get()).floatValue());
    }

    private StyledText buildUnicodeInputs(SpellDirection[] dirs, boolean small) {
        String[] icons = (String[])Arrays.stream(dirs).map(d -> small ? d.getSmallIcon() : d.getFullIcon()).toArray(String[]::new);
        String noClick = small ? SMALL_NO_CLICK_CHARACTER : FULL_NO_CLICK_CHARACTER;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (i > 0) {
                sb.append(" ").append(SEPARATOR_CHARACTER).append(" ");
            }
            sb.append(i < icons.length ? icons[i] : noClick);
        }
        class_5250 component = class_2561.method_43470((String)sb.toString()).method_27696(class_2583.field_24360.method_27704(SPELL_INPUTS_FONT));
        return StyledText.fromComponent((class_2561)component);
    }

    private StyledText buildLegacyInputs(SpellDirection[] dirs) {
        class_5250 component = class_2561.method_43473();
        String[] icons = (String[])Arrays.stream(dirs).map(d -> d.name().substring(0, 1)).toArray(String[]::new);
        int firstMissingIndex = icons.length;
        for (int i = 0; i < 3; ++i) {
            if (i < icons.length) {
                component.method_10852((class_2561)class_2561.method_43470((String)icons[i]).method_27694(style -> style.method_10977(class_124.field_1060)));
            } else {
                class_5250 noInput = class_2561.method_43470((String)"?").method_27694(style -> style.method_10977(class_124.field_1080));
                if (i == firstMissingIndex) {
                    noInput = noInput.method_27694(style -> style.method_30938(Boolean.valueOf(true)));
                }
                component.method_10852((class_2561)noInput);
            }
            if (i == 2) continue;
            component.method_10852((class_2561)class_2561.method_43470((String)"-").method_27694(style -> style.method_10977(class_124.field_1080)));
        }
        return StyledText.fromComponent((class_2561)component);
    }

    private static enum SpellInputStyle {
        ORIGINAL,
        FULL,
        SMALL,
        LEGACY;

    }
}

