/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.territories.GuildAttackScoreboardPart;
import com.wynntils.models.territories.TerritoryAttackTimer;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Comparator;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class TerritoryAttackTimerOverlay
extends Overlay {
    @Persisted
    private final Config<Boolean> disableAttackTimersOnScoreboard = new Config<Boolean>(true);
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    private TextRenderSetting textRenderSetting;

    public TerritoryAttackTimerOverlay() {
        super(new OverlayPosition(165.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(250.0f, 110.0f), HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
        this.updateTextRenderSetting();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableAttackTimersOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof GuildAttackScoreboardPart) {
            event.setCanceled(true);
        }
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.method_51448(), bufferSource, this.getRenderX(), this.getRenderY(), Models.GuildAttackTimer.getAttackTimers().stream().sorted(Comparator.comparing(TerritoryAttackTimer::asSeconds)).map(territoryAttackTimer -> new TextRenderTask(territoryAttackTimer.asString(), this.textRenderSetting)).toList(), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        BufferedFontRenderer.getInstance().renderTextWithAlignment(guiGraphics.method_51448(), bufferSource, this.getRenderX(), this.getRenderY(), new TextRenderTask(String.valueOf(class_124.field_1080) + "Detlas" + String.valueOf(class_124.field_1061) + " (High)" + String.valueOf(class_124.field_1075) + " 02:31", this.textRenderSetting), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSetting();
    }

    private void updateTextRenderSetting() {
        this.textRenderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }
}

