/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.type.BossBarProgress;
import com.wynntils.models.abilities.AbilityModel;
import com.wynntils.models.abilities.bossbars.ManaBankBar;
import com.wynntils.overlays.gamebars.ManaBarOverlay;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class ManaBankBarOverlay
extends ManaBarOverlay {
    public ManaBankBarOverlay() {
        super(new OverlayPosition(-30.0f, -150.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f));
    }

    @Override
    public String icon() {
        return "\u2604";
    }

    @Override
    public BossBarProgress progress() {
        return AbilityModel.manaBankBar.getBarProgress();
    }

    @Override
    protected Class<? extends TrackedBar> getTrackedBarClass() {
        return ManaBankBar.class;
    }

    @Override
    public boolean isVisible() {
        return AbilityModel.manaBankBar.isActive();
    }

    @Override
    protected void renderBar(class_4587 poseStack, class_4597 bufferSource, float renderY, float renderHeight, float progress) {
        int textureY1 = this.getTextureY1();
        int textureY2 = this.getTextureY2();
        Texture texture = this.getTexture();
        float x1 = this.getRenderX();
        float x2 = this.getRenderX() + this.getWidth();
        int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
        BufferedRenderUtils.drawProgressBarBackground(poseStack, bufferSource, texture, x1, renderY, x2, renderY + renderHeight, 0, textureY1, 81, half);
        if (progress == 1.0f) {
            BufferedRenderUtils.drawProgressBarForeground(poseStack, bufferSource, this.getOverflowTexture(), x1, renderY, x2, renderY + renderHeight, 0, half, 81, textureY2 + (textureY2 - textureY1) % 2, 1.0f);
        } else {
            BufferedRenderUtils.drawProgressBarForeground(poseStack, bufferSource, texture, x1, renderY, x2, renderY + renderHeight, 0, half, 81, textureY2 + (textureY2 - textureY1) % 2, progress);
        }
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
    }
}

