/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.infobox;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.TextOverlay;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ErrorOr;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;

public class InfoBoxOverlay
extends TextOverlay
implements CustomNameProperty {
    @Persisted
    private final HiddenConfig<String> customName = new HiddenConfig<String>("");
    @Persisted
    private final Config<String> content = new Config<String>("");
    @Persisted
    private final Config<String> colorTemplate = new Config<String>("");
    private ErrorOr<CustomColor> colorCache = ErrorOr.of(CommonColors.WHITE);

    public InfoBoxOverlay(int id) {
        super(id);
    }

    @Override
    public String getTemplate() {
        return (String)this.content.get();
    }

    @Override
    public String getPreviewTemplate() {
        if (!((String)this.content.get()).isEmpty()) {
            return (String)this.content.get();
        }
        return "&cX: {x(my_loc):0}, &9Y: {y(my_loc):0}, &aZ: {z(my_loc):0}";
    }

    @Override
    protected void renderOrErrorMessage(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        if (this.colorCache.hasError()) {
            StyledText[] errorMessage = new StyledText[]{StyledText.fromString("\u00a7c\u00a7l" + class_1074.method_4662((String)"feature.wynntils.customBarsOverlay.overlay.universalTexturedCustomBar.colorTemplate.error", (Object[])new Object[0]) + " " + this.getTranslatedName()), StyledText.fromUnformattedString(this.colorCache.getError())};
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), bufferSource, errorMessage, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        } else {
            super.renderOrErrorMessage(guiGraphics, bufferSource, deltaTracker, window);
        }
    }

    @Override
    protected CustomColor getRenderColor() {
        return this.colorCache.hasError() ? CommonColors.WHITE : this.colorCache.getValue();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isRendered()) {
            return;
        }
        String template = (String)this.colorTemplate.get();
        if (template.isBlank()) {
            this.colorCache = ErrorOr.of(CommonColors.WHITE);
            return;
        }
        String formattedText = StyledText.join("", Managers.Function.doFormatLines(template)).getString();
        this.colorCache = Managers.Function.tryGetRawValueOfType(formattedText, CustomColor.class);
    }

    @Override
    public Config<String> getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String newName) {
        this.customName.setValue(newName);
    }
}

