/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.objectives;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.objectives.DailyObjectiveScoreboardPart;
import com.wynntils.models.objectives.WynnObjective;
import com.wynntils.overlays.objectives.ObjectiveOverlayBase;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.ObjectivesTextures;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class DailyObjectiveOverlay
extends ObjectiveOverlayBase {
    @Persisted
    private final Config<Boolean> disableObjectiveTrackingOnScoreboard = new Config<Boolean>(true);
    @Persisted(i18nKey="feature.wynntils.objectivesOverlay.overlay.objectiveOverlayBase.textColor")
    private final Config<CustomColor> textColor = new Config<CustomColor>(CommonColors.GREEN);

    public DailyObjectiveOverlay() {
        super(new OverlayPosition(-35.0f, -5.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.BOTTOM_RIGHT), new OverlaySize(150.0f, 100.0f), HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableObjectiveTrackingOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof DailyObjectiveScoreboardPart) {
            event.setCanceled(true);
            return;
        }
    }

    @Override
    protected boolean isVisible() {
        return !Models.Objectives.getPersonalObjectives().isEmpty();
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        List<WynnObjective> objectives = Models.Objectives.getPersonalObjectives();
        class_4587 poseStack = guiGraphics.method_51448();
        int barHeight = (Boolean)this.enableProgressBar.get() != false ? 5 : 0;
        int barWidth = 182;
        float actualBarHeight = (float)barHeight * (this.getWidth() / 182.0f);
        float renderedHeightWithoutTextHeight = 10.0f + actualBarHeight;
        int tempHeight = 0;
        for (WynnObjective objective : objectives) {
            tempHeight = (int)((float)tempHeight + FontRenderer.getInstance().calculateRenderHeight(objective.asObjectiveString(), (float)((int)this.getWidth())));
        }
        float fullHeight = renderedHeightWithoutTextHeight * (float)objectives.size() - 10.0f + (float)tempHeight;
        float offsetY = switch (this.getRenderVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> 0.0f;
            case VerticalAlignment.MIDDLE -> (this.getHeight() - fullHeight) / 2.0f;
            case VerticalAlignment.BOTTOM -> this.getHeight() - fullHeight;
        };
        for (WynnObjective objective : objectives) {
            if (((Boolean)this.hideOnInactivity.get()).booleanValue()) {
                int maxInactivityMs = 3000;
                if (objective.getUpdatedAt() + 3000L < System.currentTimeMillis()) continue;
            }
            float renderY = offsetY + this.getRenderY();
            String text = objective.asObjectiveString();
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(text), this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, this.getWidth(), (CustomColor)this.textColor.get(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
            float textHeight = FontRenderer.getInstance().calculateRenderHeight(text, (float)((int)this.getWidth()));
            if (textHeight > 9.0f) {
                renderY += textHeight - 9.0f;
            }
            if (((Boolean)this.enableProgressBar.get()).booleanValue()) {
                BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.EXPERIENCE_BAR, this.getRenderX(), renderY + 10.0f, this.getRenderX() + this.getWidth(), renderY + 10.0f + actualBarHeight, 0, ((ObjectivesTextures)this.objectivesTexture.get()).getTextureY1(), 182, ((ObjectivesTextures)this.objectivesTexture.get()).getTextureY2(), objective.getProgress());
            }
            offsetY += renderedHeightWithoutTextHeight + textHeight;
        }
    }
}

