/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.chattabs;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.TextWidget;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.chattabs.widgets.ChatTabsWidget;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public final class ChatTabEditingScreen
extends WynntilsGridLayoutScreen {
    private static final int HEADER_ROW_Y = 6;
    private static final int FIRST_ROW_Y = 11;
    private static final int SECOND_ROW_Y = 22;
    private static final int THIRD_ROW_Y = 40;
    private static final int FOURTH_ROW_Y = 47;
    private static final int FIFTH_ROW_Y = 54;
    private List<class_339> chatTabsWidgets = new ArrayList<class_339>();
    private TextInputBoxWidget nameInput;
    private TextInputBoxWidget autoCommandInput;
    private TextInputBoxWidget orderInput;
    private final List<WynntilsCheckbox> recipientTypeBoxes = new ArrayList<WynntilsCheckbox>();
    private TextInputBoxWidget filterRegexInput;
    private TextWidget regexErrorMsg;
    private WynntilsCheckbox consumingCheckbox;
    private class_4185 saveButton;
    private class_4185 saveAndCloseButton;
    private boolean firstSetup;
    private final ChatTab edited;

    private ChatTabEditingScreen() {
        this((ChatTab)null);
    }

    private ChatTabEditingScreen(ChatTab tab) {
        super((class_2561)class_2561.method_43470((String)"Chat Tab Editing Screen"));
        this.edited = tab;
        this.firstSetup = true;
    }

    public static class_437 create() {
        return new ChatTabEditingScreen();
    }

    public static class_437 create(ChatTab chatTab) {
        return new ChatTabEditingScreen(chatTab);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.reloadChatTabsWidgets();
        this.nameInput = new TextInputBoxWidget((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 10.0f), 20, s -> this.updateSaveButtonActive(), this, this.nameInput);
        this.method_37063((class_364)this.nameInput);
        if (this.firstSetup) {
            if (this.edited != null) {
                this.nameInput.setTextBoxInput(this.edited.name());
            }
            this.setFocusedTextInput(this.nameInput);
        }
        this.autoCommandInput = new TextInputBoxWidget((int)(this.dividedWidth * 47.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 10.0f), 20, null, this, this.autoCommandInput);
        this.method_37063((class_364)this.autoCommandInput);
        if (this.firstSetup && this.edited != null && this.edited.autoCommand() != null) {
            this.autoCommandInput.setTextBoxInput(this.edited.autoCommand());
        }
        this.orderInput = new TextInputBoxWidget((int)(this.dividedWidth * 59.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 2.0f), 20, s -> this.updateSaveButtonActive(), this, this.orderInput);
        this.method_37063((class_364)this.orderInput);
        if (this.firstSetup && this.edited != null) {
            this.orderInput.setTextBoxInput(Integer.toString(Services.ChatTab.getTabIndex(this.edited)));
        }
        ArrayList<WynntilsCheckbox> oldBoxes = new ArrayList<WynntilsCheckbox>(this.recipientTypeBoxes);
        this.recipientTypeBoxes.clear();
        int x = (int)(this.dividedWidth * 35.0f);
        int y = (int)(this.dividedHeight * 22.0f);
        for (int i = 0; i < RecipientType.values().length; ++i) {
            if (i == 4 || i == 8) {
                y += (int)(this.dividedHeight * 5.0f);
                x = (int)(this.dividedWidth * 35.0f);
            }
            RecipientType type = RecipientType.values()[i];
            WynntilsCheckbox oldCheckbox = oldBoxes.stream().filter(checkbox -> checkbox.method_25369().getString().equals(type.getName())).findFirst().orElse(null);
            boolean oldCheckboxSelected = oldCheckbox != null && oldCheckbox.isSelected();
            boolean editedFirstSetupSelected = this.firstSetup && this.edited != null && (this.edited.filteredTypes() == null || this.edited.filteredTypes().contains((Object)type));
            boolean ticked = oldCheckboxSelected || editedFirstSetupSelected;
            WynntilsCheckbox newBox = new WynntilsCheckbox(x, y, 20, (class_2561)class_2561.method_43470((String)type.getName()), ticked, (int)(this.dividedWidth * 7.0f) - 24);
            this.method_37063((class_364)newBox);
            this.recipientTypeBoxes.add(newBox);
            x += (int)(this.dividedWidth * 7.0f);
        }
        this.filterRegexInput = new TextInputBoxWidget((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 40.0f), (int)(this.dividedWidth * 26.0f), 20, s -> this.updateSaveButtonActive(), this, this.filterRegexInput);
        this.method_37063((class_364)this.filterRegexInput);
        if (this.firstSetup && this.edited != null && this.edited.customRegexString() != null) {
            this.filterRegexInput.setTextBoxInput(this.edited.customRegexString());
        }
        this.regexErrorMsg = new TextWidget(this.field_22789 / 2 - 160 + 100, this.field_22790 / 2 + 75 + 7, 200, 20, (class_2561)class_2561.method_43473());
        this.method_37063((class_364)this.regexErrorMsg);
        this.consumingCheckbox = new WynntilsCheckbox((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 47.0f), 20, (class_2561)class_2561.method_43471((String)"screens.wynntils.chatTabsGui.consuming"), this.consumingCheckbox != null && this.consumingCheckbox.isSelected(), (int)(this.dividedWidth * 15.0f));
        this.method_37063((class_364)this.consumingCheckbox);
        if (this.firstSetup && this.edited != null) {
            this.consumingCheckbox.selected = this.edited.consuming();
        }
        String saveButtonKey = this.edited == null ? "screens.wynntils.chatTabsGui.add" : "screens.wynntils.chatTabsGui.save";
        this.saveButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)saveButtonKey).method_27692(class_124.field_1060), button -> {
            this.saveChatTab();
            this.reloadChatTabsWidgets();
        }).method_46433((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 54.0f)).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        String saveAndCloseButtonKey = this.edited == null ? "screens.wynntils.chatTabsGui.addAndClose" : "screens.wynntils.chatTabsGui.saveAndClose";
        this.saveAndCloseButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)saveAndCloseButtonKey).method_27692(class_124.field_1060), button -> {
            this.saveChatTab();
            this.method_25419();
        }).method_46433((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 54.0f)).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.method_37063((class_364)this.saveAndCloseButton);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.chatTabsGui.cancel"), button -> this.method_25419()).method_46433((int)(this.dividedWidth * 53.0f), (int)(this.dividedHeight * 54.0f)).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431());
        this.firstSetup = false;
        this.updateSaveButtonActive();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        this.chatTabsWidgets.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        if (this.edited == null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.create", (Object[])new Object[0])), this.dividedWidth * 48.0f, this.dividedHeight * 6.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        } else {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.edit", (Object[])new Object[]{this.edited.name()})), this.dividedWidth * 48.0f, this.dividedHeight * 6.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.name", (Object[])new Object[0]) + String.valueOf(class_124.field_1079) + " *"), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.autoCommand", (Object[])new Object[0])), (int)(this.dividedWidth * 47.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.order", (Object[])new Object[0])), (int)(this.dividedWidth * 59.0f), (int)(this.dividedHeight * 11.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.types", (Object[])new Object[0]) + String.valueOf(class_124.field_1079) + " *"), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 21.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.chatTabsGui.filter", (Object[])new Object[0])), (int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 40.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (class_339 widget : this.chatTabsWidgets) {
            if (!widget.method_25405(mouseX, mouseY)) continue;
            return widget.method_25402(mouseX, mouseY, button);
        }
        if (this.saveButton.method_25405(mouseX, mouseY)) {
            return this.saveButton.method_25402(mouseX, mouseY, button);
        }
        if (this.saveAndCloseButton.method_25405(mouseX, mouseY)) {
            return this.saveAndCloseButton.method_25402(mouseX, mouseY, button);
        }
        boolean mouseClicked = super.doMouseClicked(mouseX, mouseY, button);
        this.updateSaveButtonActive();
        return mouseClicked;
    }

    public void method_25419() {
        McUtils.mc().method_1507((class_437)new class_408(""));
    }

    private void saveChatTab() {
        if (this.edited != null) {
            Services.ChatTab.removeTab(this.edited);
        }
        int insertIndex = this.orderInput.getTextBoxInput().isEmpty() ? Services.ChatTab.getTabCount() : Math.min(Services.ChatTab.getTabCount(), Integer.parseInt(this.orderInput.getTextBoxInput()));
        ChatTab chatTab = new ChatTab(this.nameInput.getTextBoxInput(), this.consumingCheckbox.isSelected(), this.autoCommandInput.getTextBoxInput(), this.recipientTypeBoxes.stream().filter(WynntilsCheckbox::isSelected).map(box -> RecipientType.fromName(box.method_25369().getString())).collect(Collectors.toSet()), this.filterRegexInput.getTextBoxInput().isBlank() ? null : this.filterRegexInput.getTextBoxInput());
        Services.ChatTab.addTab(insertIndex, chatTab);
        McUtils.mc().method_1507(ChatTabEditingScreen.create(chatTab));
    }

    private void updateSaveButtonActive() {
        if (this.orderInput != null && !this.orderInput.getTextBoxInput().isBlank()) {
            try {
                Integer.parseInt(this.orderInput.getTextBoxInput());
                this.orderInput.setRenderColor(CommonColors.GREEN);
            }
            catch (NumberFormatException ignored) {
                this.orderInput.setRenderColor(CommonColors.RED);
                this.saveButton.field_22763 = false;
                this.saveAndCloseButton.field_22763 = false;
            }
        }
        if (this.saveButton == null || this.saveAndCloseButton == null) {
            return;
        }
        this.saveAndCloseButton.field_22763 = this.saveButton.field_22763 = !this.nameInput.getTextBoxInput().isEmpty() && this.validatePattern() && this.recipientTypeBoxes.stream().anyMatch(WynntilsCheckbox::isSelected);
    }

    private boolean validatePattern() {
        try {
            Pattern.compile(this.filterRegexInput.getTextBoxInput());
            this.regexErrorMsg.method_25355((class_2561)class_2561.method_43473());
        }
        catch (PatternSyntaxException e) {
            class_5250 errorMessage = class_2561.method_43470((String)e.getDescription()).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)(" (at pos " + e.getIndex() + ")")).method_27692(class_124.field_1079));
            this.regexErrorMsg.method_25355((class_2561)errorMessage);
            return false;
        }
        return true;
    }

    public boolean isActiveChatTab(ChatTab chatTab) {
        return this.edited != null && this.edited.equals(chatTab);
    }

    public void reloadChatTabsWidgets() {
        this.chatTabsWidgets = new ArrayList<class_339>();
        List<ChatTab> chatTabs = Services.ChatTab.getChatTabs();
        int initialVerticalOffset = (int)(this.dividedHeight * 32.0f) - (int)((this.dividedHeight * (float)(chatTabs.size() * 5 + 1) + 20.0f) / 2.0f);
        for (int i = 0; i < chatTabs.size(); ++i) {
            this.chatTabsWidgets.add(new ChatTabsWidget(this.dividedWidth * 3.0f, (float)initialVerticalOffset + this.dividedHeight * (float)(i * 5), (int)(this.dividedWidth * 29.0f) - (int)(this.dividedWidth * 3.0f), (int)(this.dividedHeight * 4.0f), chatTabs.get(i), 26.0f, this));
        }
        class_124 color = this.edited == null ? class_124.field_1060 : class_124.field_1068;
        this.chatTabsWidgets.add((class_339)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.chatTabsGui.new").method_27692(color), button -> McUtils.mc().method_1507(ChatTabEditingScreen.create())).method_46433((int)(this.dividedWidth * 13.0f), initialVerticalOffset + (int)(this.dividedHeight * (float)(chatTabs.size() * 5 + 1))).method_46437((int)(this.dividedWidth * 6.0f), 20).method_46431());
    }
}

