/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.downloads.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.net.DownloadDependencyGraph;
import com.wynntils.core.net.QueuedDownload;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class DownloadWidget
extends class_339 {
    private static final List<class_2561> DOWNLOAD_TOOLTIP = List.of(class_2561.method_43471((String)"screens.wynntils.downloads.tryRedownload"));
    private static final String dataPattern = "Data (Static|Athena) ";
    private final QueuedDownload download;
    private final String downloadName;
    private float offset = 0.0f;

    public DownloadWidget(int x, int y, int width, int height, QueuedDownload download) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Download Widget"));
        this.download = download;
        this.downloadName = EnumUtils.toNiceString(download.urlId()).replaceFirst(dataPattern, "");
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        DownloadDependencyGraph.DownloadDependencyGraphState managerState = Managers.Download.graphState();
        RenderUtils.drawRect(guiGraphics.method_51448(), CommonColors.GRAY.withAlpha(this.field_22762 ? 200 : 100), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        DownloadDependencyGraph.NodeState downloadState = Managers.Download.getDownloadState(this.download);
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(this.downloadName), (float)this.method_46426() + (float)this.field_22758 / 2.0f, (float)this.method_46427() + (float)this.field_22759 / 2.0f, downloadState == DownloadDependencyGraph.NodeState.COMPLETED ? CommonColors.GREEN : CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (downloadState == DownloadDependencyGraph.NodeState.WAITING_ON_DEPENDENCY || downloadState == DownloadDependencyGraph.NodeState.IN_PROGRESS || downloadState == DownloadDependencyGraph.NodeState.QUEUED) {
            this.offset = (float)((double)(this.offset + 0.1f) % (Math.PI * 2));
            int outerRadius = (int)((float)this.field_22759 * 0.5f);
            float arcY = (float)this.method_46427() + (float)this.field_22759 / 2.0f - (float)outerRadius;
            int innerRadius = (int)((float)outerRadius * 0.85f);
            RenderUtils.drawArc(guiGraphics.method_51448(), CommonColors.BLACK, this.method_46426() + this.method_25368() - this.field_22759, arcY, 0.0f, 0.8f, innerRadius, outerRadius, this.offset);
        }
        if (this.field_22762) {
            McUtils.mc().field_1755.method_47414(Lists.transform(DOWNLOAD_TOOLTIP, class_2561::method_30937));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            Managers.Download.retryDownload(this.download);
        }
        catch (IllegalStateException e) {
            WynntilsMod.warn("Retrying download caused an exception", e);
        }
        return true;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

