/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.tome;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.tome.GuideTomeItemStack;
import com.wynntils.screens.guides.tome.GuideTomeItemStackButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.screens.guides.widgets.filters.RarityFilterWidget;
import com.wynntils.screens.guides.widgets.filters.TomeTypeFilterWidget;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.services.itemfilter.statproviders.RarityStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class WynntilsTomeGuideScreen
extends WynntilsGuideScreen<GuideTomeItemStack, GuideTomeItemStackButton> {
    private static final int ELEMENTS_COLUMNS = 7;
    private static final int ELEMENT_ROWS = 7;
    private List<GuideTomeItemStack> allTomeItems = List.of();

    private WynntilsTomeGuideScreen() {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.tomeGuide.name"), List.of(ItemProviderType.GENERIC, ItemProviderType.GEAR));
    }

    public static class_437 create() {
        return new WynntilsTomeGuideScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.add((GuideFilterWidget)this.method_37063((class_364)new TomeTypeFilterWidget(19 + this.offsetX, 81 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideFilterWidgets.add((GuideFilterWidget)this.method_37063((class_364)new RarityFilterWidget(19 + this.offsetX, 101 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget.setSecondarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, RarityStatProvider.class));
        } else {
            WynntilsMod.error("WynntilsTomeGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.tomeGuide.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderItemsHeader(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_4068 class_40682 = this.hovered;
        if (class_40682 instanceof GuideTomeItemStackButton) {
            GuideTomeItemStackButton guideTomeItemStackButton = (GuideTomeItemStackButton)class_40682;
            guiGraphics.method_51446(FontRenderer.getInstance().getFont(), (class_1799)guideTomeItemStackButton.getItemStack(), mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderItemsHeader(class_4587 poseStack) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.itemGuide.available", (Object[])new Object[0])), (float)Texture.CONTENT_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX, 30 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
    }

    @Override
    protected GuideTomeItemStackButton getButtonFromElement(int i) {
        int xOffset = i % 7 * 20;
        int yOffset = i % this.getElementsPerPage() / 7 * 20;
        return new GuideTomeItemStackButton((int)((float)xOffset + (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 13.0f + (float)this.offsetX), yOffset + 43 + this.offsetY, 18, 18, (GuideTomeItemStack)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(ItemSearchQuery searchQuery) {
        this.elements.addAll(Services.ItemFilter.filterAndSort(searchQuery, this.getAllTomeItems()));
        this.guideFilterWidgets.forEach(filter -> filter.updateFromQuery(searchQuery));
        if (this.guideSortWidget == null) {
            return;
        }
        this.guideSortWidget.updateFromQuery(searchQuery);
    }

    private List<GuideTomeItemStack> getAllTomeItems() {
        if (this.allTomeItems.isEmpty()) {
            this.allTomeItems = Models.Rewards.getAllTomeInfos().map(GuideTomeItemStack::new).toList();
        }
        return this.allTomeItems;
    }

    @Override
    protected int getElementsPerPage() {
        return 49;
    }
}

