/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.BooleanStatFilter;
import com.wynntils.services.itemfilter.statproviders.ProfessionStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class ProfessionTypeFilterWidget
extends GuideFilterWidget {
    private final List<ProfessionTypeButton> professionTypeButtons = new ArrayList<ProfessionTypeButton>();
    private Map<ProfessionType, ProfessionStatProvider> professionProviderMap;

    public ProfessionTypeFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 76, 36, guideScreen);
        this.professionTypeButtons.add(new ProfessionTypeButton(x, y, ProfessionType.ALCHEMISM, Texture.ALCHEMISM_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 20, y, ProfessionType.ARMOURING, Texture.ARMOURING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 40, y, ProfessionType.COOKING, Texture.COOKING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 60, y, ProfessionType.JEWELING, Texture.JEWELING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x, y + 20, ProfessionType.SCRIBING, Texture.SCRIBING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 20, y + 20, ProfessionType.TAILORING, Texture.TAILORING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 40, y + 20, ProfessionType.WEAPONSMITHING, Texture.WEAPONSMITHING_FILTER_ICON, searchQuery));
        this.professionTypeButtons.add(new ProfessionTypeButton(x + 60, y + 20, ProfessionType.WOODWORKING, Texture.WOODWORKING_FILTER_ICON, searchQuery));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.professionTypeButtons.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (ProfessionTypeButton professionTypeButton : this.professionTypeButtons) {
            if (!professionTypeButton.method_25405(mouseX, mouseY)) continue;
            clicked = professionTypeButton.method_25402(mouseX, mouseY, button);
            break;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return clicked;
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        ArrayList<StatProviderAndFilterPair> filterPairs = new ArrayList<StatProviderAndFilterPair>();
        for (ProfessionTypeButton professionTypeButton : this.professionTypeButtons) {
            StatProviderAndFilterPair filterPair = professionTypeButton.getFilterPair(this.professionProviderMap.get(professionTypeButton.professionType));
            if (filterPair == null) continue;
            filterPairs.add(filterPair);
        }
        return filterPairs;
    }

    @Override
    public void getProvider() {
        this.professionProviderMap = new HashMap<ProfessionType, ProfessionStatProvider>();
        Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof ProfessionStatProvider).map(statProvider -> (ProfessionStatProvider)statProvider).forEach(professionStatProvider -> {
            ProfessionType type = ProfessionType.fromString(professionStatProvider.getDisplayName());
            this.professionProviderMap.put(type, (ProfessionStatProvider)professionStatProvider);
        });
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        this.professionTypeButtons.forEach(classTypeButton -> classTypeButton.updateStateFromQuery(searchQuery));
    }

    private static class ProfessionTypeButton
    extends GuideFilterButton<ProfessionStatProvider> {
        private final ProfessionType professionType;
        private ConfirmedBoolean state;

        protected ProfessionTypeButton(int x, int y, ProfessionType professionType, Texture texture, ItemSearchQuery searchQuery) {
            super(x, y, texture);
            this.professionType = professionType;
            this.updateStateFromQuery(searchQuery);
        }

        @Override
        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderUtils.drawTexturedRect(guiGraphics.method_51448(), this.texture, this.method_46426(), this.method_46427());
            if (!this.field_22762 && this.state == ConfirmedBoolean.UNCONFIRMED) {
                return;
            }
            CustomColor color = CommonColors.WHITE;
            if (this.state == ConfirmedBoolean.TRUE) {
                color = CommonColors.LIGHT_GREEN;
            } else if (this.state == ConfirmedBoolean.FALSE) {
                color = CommonColors.RED;
            }
            RenderUtils.drawRect(guiGraphics.method_51448(), color.withAlpha(this.field_22762 ? 0.7f : 0.5f), this.method_46426(), this.method_46427(), 0.0f, this.method_25368(), this.method_25364());
            if (this.field_22762) {
                McUtils.mc().field_1755.method_47414(Lists.transform(ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.wynntilsGuides.filterWidget.tooltip", (Object[])new Object[]{this.getFilterName()})), 200), class_2561::method_30937));
            }
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0 || button == 1) {
                if (this.state != ConfirmedBoolean.TRUE) {
                    this.state = ConfirmedBoolean.TRUE;
                } else if (this.state != ConfirmedBoolean.FALSE) {
                    this.state = ConfirmedBoolean.FALSE;
                }
            } else if (button == 2) {
                this.state = ConfirmedBoolean.UNCONFIRMED;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        @Override
        protected void updateStateFromQuery(ItemSearchQuery searchQuery) {
            Optional<StatProviderAndFilterPair> filterPairOpt = searchQuery.filters().values().stream().filter(filterPair -> {
                ItemStatProvider patt0$temp = filterPair.statProvider();
                if (patt0$temp instanceof ProfessionStatProvider) {
                    ProfessionStatProvider professionStatProvider = (ProfessionStatProvider)patt0$temp;
                    return professionStatProvider.getDisplayName().equals(this.professionType.getDisplayName());
                }
                return false;
            }).findFirst();
            if (filterPairOpt.isPresent()) {
                if (filterPairOpt.get().statFilter().matches(true)) {
                    this.state = ConfirmedBoolean.TRUE;
                } else if (filterPairOpt.get().statFilter().matches(false)) {
                    this.state = ConfirmedBoolean.FALSE;
                }
            } else {
                this.state = ConfirmedBoolean.UNCONFIRMED;
            }
        }

        @Override
        protected StatProviderAndFilterPair getFilterPair(ProfessionStatProvider provider) {
            if (this.state == ConfirmedBoolean.UNCONFIRMED) {
                return null;
            }
            return new StatProviderAndFilterPair<Boolean>(provider, new BooleanStatFilter.BooleanStatFilterFactory().fromBoolean(this.state == ConfirmedBoolean.TRUE));
        }

        @Override
        protected String getFilterName() {
            return this.professionType.getDisplayName();
        }
    }
}

