/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guildlog;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.wrappedscreen.WrappedScreenHolder;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.guild.type.GuildLogType;
import com.wynntils.models.items.items.gui.GuildLogItem;
import com.wynntils.screens.guildlog.GuildLogScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.neoforged.bus.api.SubscribeEvent;

public class GuildLogHolder
extends WrappedScreenHolder<GuildLogScreen> {
    private static final Pattern TITLE_PATTERN = Pattern.compile(".+'s? Log: (.+)");
    public static final int BACK_BUTTON_SLOT = 0;
    private static final int FORCED_LOAD_DELAY = 20;
    private static final int LOGS_PER_PAGE = 32;
    private static final int NEXT_PAGE_SLOT = 45;
    private static final int REQUEST_TIMEOUT = 5;
    protected static final Map<GuildLogType, Integer> LOG_SLOTS_MAP = Map.of(GuildLogType.GENERAL, 2, GuildLogType.OBJECTIVES, 3, GuildLogType.WARS, 4, GuildLogType.ECONOMY, 5, GuildLogType.PUBLIC_BANK, 6, GuildLogType.HIGH_RANKED_BANK, 7);
    public List<GuildLogItem> guildLogItems = new ArrayList<GuildLogItem>();
    private GuildLogScreen wrappedScreen;
    private int loadedLogs = 0;
    private long nextRequestTicks;
    private long lastItemLoadedTicks;

    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Post event) {
        if (event.getContainerId() != this.wrappedScreen.getWrappedScreenInfo().containerId()) {
            return;
        }
        class_1799 itemStack = event.getItemStack();
        Optional<GuildLogItem> logItemOpt = Models.Item.asWynnItem(itemStack, GuildLogItem.class);
        if (logItemOpt.isPresent()) {
            ++this.loadedLogs;
            this.guildLogItems.add(logItemOpt.get());
            this.lastItemLoadedTicks = McUtils.player().field_6012;
            this.wrappedScreen.updateLogItems();
            if (this.loadedLogs >= 32) {
                this.nextRequestTicks = McUtils.player().field_6012 + 5;
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!this.hasNextPage()) {
            return;
        }
        if ((long)McUtils.player().field_6012 >= this.lastItemLoadedTicks + 20L) {
            WynntilsMod.warn("Forcing the next page load, as the previous one did not finish properly.");
            this.nextRequestTicks = McUtils.player().field_6012;
            this.lastItemLoadedTicks = Integer.MAX_VALUE;
        }
        if ((long)McUtils.player().field_6012 < this.nextRequestTicks) {
            return;
        }
        ContainerUtils.clickOnSlot(45, this.wrappedScreen.getWrappedScreenInfo().containerId(), 0, (List<class_1799>)this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602());
        this.loadedLogs = 0;
        this.nextRequestTicks = Integer.MAX_VALUE;
    }

    private boolean hasNextPage() {
        class_2371 items = this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602();
        return !((class_1799)items.get(45)).method_7960() && this.loadedLogs >= 32;
    }

    @Override
    protected Pattern getReplacedScreenTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    protected GuildLogScreen createWrappedScreen(WrappedScreenInfo wrappedScreenInfo) {
        return new GuildLogScreen(wrappedScreenInfo, this);
    }

    @Override
    protected void setWrappedScreen(GuildLogScreen wrappedScreen) {
        this.wrappedScreen = wrappedScreen;
    }

    @Override
    protected void reset() {
        this.loadedLogs = 0;
        this.guildLogItems = new ArrayList<GuildLogItem>();
        this.nextRequestTicks = Integer.MAX_VALUE;
    }
}

