/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guildlog;

import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.models.guild.type.GuildLogType;
import com.wynntils.models.items.items.gui.GuildLogItem;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.guildlog.GuildLogHolder;
import com.wynntils.screens.guildlog.widgets.LogButton;
import com.wynntils.screens.guildlog.widgets.LogDateWidget;
import com.wynntils.screens.guildlog.widgets.LogEntryWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.wynn.ContainerUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class GuildLogScreen
extends WynntilsScreen
implements WrappedScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int SCROLL_AREA_HEIGHT = 125;
    private List<class_339> logs = new ArrayList<class_339>();
    private boolean draggingScroll = false;
    private float scrollY;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private final WrappedScreenInfo wrappedScreenInfo;
    private final GuildLogHolder holder;

    public GuildLogScreen(WrappedScreenInfo wrappedScreenInfo, GuildLogHolder holder) {
        super((class_2561)class_2561.method_43470((String)"Guild Log"));
        this.wrappedScreenInfo = wrappedScreenInfo;
        this.holder = holder;
    }

    @Override
    protected void doInit() {
        this.offsetX = (this.field_22789 - Texture.GUILD_LOG_BACKGROUND.width()) / 2;
        this.offsetY = (this.field_22790 - Texture.GUILD_LOG_BACKGROUND.height()) / 2;
        this.method_37063((class_364)new BasicTexturedButton(this.offsetX + 4, this.offsetY + 2, Texture.LOG_BACK.width(), Texture.LOG_BACK.height(), Texture.LOG_BACK, button -> ContainerUtils.clickOnSlot(0, this.wrappedScreenInfo.containerId(), button, (List<class_1799>)this.wrappedScreenInfo.containerMenu().method_7602()), List.of(class_2561.method_43471((String)"gui.back").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}))));
        for (GuildLogType logType : GuildLogType.values()) {
            this.method_37063((class_364)new LogButton(this.offsetX + 9, this.offsetY + 17 + logType.ordinal() * 23, button -> ContainerUtils.clickOnSlot(GuildLogHolder.LOG_SLOTS_MAP.get((Object)logType), this.wrappedScreenInfo.containerId(), button, (List<class_1799>)this.wrappedScreenInfo.containerMenu().method_7602()), ComponentUtils.wrapTooltips(List.of(class_2561.method_43470((String)logType.getDisplayName()).method_27695(new class_124[]{logType.getColor(), class_124.field_1067}), class_2561.method_43471((String)logType.getTooltipKey()).method_27692(class_124.field_1080)), 150), logType));
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(poseStack, Texture.GUILD_LOG_BACKGROUND, this.offsetX, this.offsetY);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent(this.wrappedScreenInfo.screen().method_25440()), this.offsetX + 20, this.offsetY + 10, CommonColors.TITLE_GRAY, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NONE);
        this.renderLogs(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScroll(poseStack);
        this.field_33816.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 393, this.offsetX + 393 + Texture.SCROLL_BUTTON.width(), (int)this.scrollY, (int)(this.scrollY + (float)Texture.SCROLL_BUTTON.height()))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.offsetY + 15 + 17;
            int scrollAreaHeight = 125 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.maxScrollOffset));
            newOffset = Math.max(0, Math.min(newOffset, this.maxScrollOffset));
            this.scroll(newOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.maxScrollOffset));
        this.scroll(newOffset);
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void updateLogItems() {
        this.logs = new ArrayList<class_339>();
        this.maxScrollOffset = 0;
        LocalDate currentDate = null;
        int renderX = this.offsetX + 108;
        int renderY = this.offsetY + 17;
        for (GuildLogItem logItem : this.holder.guildLogItems) {
            Instant logInstant = logItem.getLogInstant();
            LocalDate logDate = logInstant.atZone(ZoneId.systemDefault()).toLocalDate();
            if (currentDate == null || !logDate.isEqual(currentDate)) {
                currentDate = logDate;
                LogDateWidget dateWidget = new LogDateWidget(renderX, renderY, logInstant);
                this.logs.add(dateWidget);
                dateWidget.field_22764 = renderY <= this.offsetY + 17 + 139;
                renderY += 21;
                this.maxScrollOffset += 21;
            }
            int widgetHeight = Texture.LOG_ENTRY_TOP.height() + Texture.LOG_ENTRY_BOTTOM.height() + (logItem.getLogInfo().size() + 1) * Texture.LOG_ENTRY_MIDDLE.height();
            LogEntryWidget entryWidget = new LogEntryWidget(renderX, renderY, widgetHeight, logItem.getLogInfo(), logInstant);
            this.logs.add(entryWidget);
            entryWidget.field_22764 = renderY <= this.offsetY + 17 + 139;
            renderY += widgetHeight + 1;
            this.maxScrollOffset += widgetHeight + 1;
        }
        this.maxScrollOffset -= 121 + Texture.SCROLL_BUTTON.height();
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        int currentY = this.offsetY + 17;
        for (class_339 widget : this.logs) {
            int newY = currentY - this.scrollOffset;
            widget.method_46419(newY);
            widget.field_22764 = newY <= this.offsetY + 17 + 139 && newY + widget.method_25364() >= this.offsetY + 17;
            currentY += widget.method_25364() + 1;
        }
    }

    private void renderLogs(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, this.offsetX + 108, this.offsetY + 16, Texture.LOG_ENTRY_MIDDLE.width(), 139);
        this.logs.forEach(log -> log.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderScroll(class_4587 poseStack) {
        this.scrollY = (float)(this.offsetY + 15) + MathUtils.map(this.scrollOffset, 0.0f, this.maxScrollOffset, 0.0f, 141 - Texture.SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, this.offsetX + 393, this.scrollY);
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }
}

