/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public abstract class RangedNumericFilterWidget<T>
extends GeneralFilterWidget {
    private final class_4185 removeButton;
    private final TextInputBoxWidget minInput;
    private final TextInputBoxWidget maxInput;
    private boolean ignoreUpdate = false;

    protected RangedNumericFilterWidget(int x, int y, int width, int height, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Ranged Numeric Filter Widget"), parent);
        this.minInput = new TextInputBoxWidget(this.method_46426(), this.method_46427(), 50, this.method_25364(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.maxInput = new TextInputBoxWidget(this.method_46426() + 67, this.method_46427(), 50, this.method_25364(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.removeButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).method_46433(this.method_46426() + width - 20, this.method_46427()).method_46437(20, 20).method_46431();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.minInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.maxInput.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString("-"), this.method_46426() + 59, this.method_46427() + 11, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.minInput.method_25405(mouseX, mouseY)) {
            return this.minInput.method_25402(mouseX, mouseY, button);
        }
        if (this.maxInput.method_25405(mouseX, mouseY)) {
            return this.maxInput.method_25402(mouseX, mouseY, button);
        }
        if (this.removeButton.method_25405(mouseX, mouseY)) {
            return this.removeButton.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.minInput.method_25405(mouseX, mouseY)) {
            return this.minInput.method_25406(mouseX, mouseY, button);
        }
        if (this.maxInput.method_25405(mouseX, mouseY)) {
            return this.maxInput.method_25406(mouseX, mouseY, button);
        }
        if (this.removeButton.method_25405(mouseX, mouseY)) {
            return this.removeButton.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.method_46419(y);
        this.minInput.method_46419(y);
        this.maxInput.method_46419(y);
        this.removeButton.method_46419(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.minInput.getTextBoxInput().isEmpty() || this.maxInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        String min = this.minInput.getTextBoxInput();
        String max = this.maxInput.getTextBoxInput();
        Optional<StatFilter<StatFilter>> rangedStatFilterOpt = this.getRangedStatFilter(min, max);
        return rangedStatFilterOpt.map(statFilter -> new StatProviderAndFilterPair(this.parent.getProvider(), statFilter)).orElse(null);
    }

    protected void setMinInput(String input) {
        this.ignoreUpdate = true;
        this.minInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected void setMaxInput(String input) {
        this.ignoreUpdate = true;
        this.maxInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected abstract Optional<StatFilter<T>> getRangedStatFilter(String var1, String var2);
}

