/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.ui.CustomSeaskipperScreenFeature;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.screens.maps.widgets.SeaskipperDestinationButton;
import com.wynntils.screens.maps.widgets.SeaskipperTravelButton;
import com.wynntils.services.map.pois.SeaskipperDestinationPoi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.BoundingShape;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public final class CustomSeaskipperScreen
extends AbstractMapScreen {
    private static final int MAX_DESTINATIONS = 10;
    private static final int SCROLL_HEIGHT = 220;
    private static final int DEFAULT_ZOOM_LEVEL = 20;
    private boolean hideTerritoryBorders = false;
    private boolean renderAllDestinations = false;
    private boolean renderRoutes = false;
    private List<SeaskipperDestinationButton> destinationButtons = new ArrayList<SeaskipperDestinationButton>();
    private List<SeaskipperDestinationPoi> availablePois = new ArrayList<SeaskipperDestinationPoi>();
    private List<SeaskipperDestinationPoi> destinationPois = new ArrayList<SeaskipperDestinationPoi>();
    private SeaskipperDestinationPoi currentLocationPoi = null;
    private SeaskipperDestinationPoi hoveredPoi;
    private SeaskipperDestinationPoi selectedPoi;
    private boolean draggingScroll = false;
    private boolean firstInit = true;
    private double currentUnusedScroll = 0.0;
    private float currentTextureScale;
    private float departureBoardY;
    private float destinationButtonsRenderX;
    private float scrollButtonRenderX;
    private float scrollButtonRenderY;
    private int scrollAreaHeight;
    private int scrollOffset = 0;

    private CustomSeaskipperScreen() {
    }

    public static class_437 create() {
        return new CustomSeaskipperScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.currentTextureScale = (float)this.field_22790 / (float)(Texture.DESTINATION_LIST.height() + 49);
        float departureListWidth = (float)Texture.DESTINATION_LIST.width() * this.currentTextureScale;
        this.renderX += departureListWidth;
        this.renderWidth -= departureListWidth;
        this.centerX += departureListWidth / 2.0f;
        this.renderedBorderXOffset -= 1.0f;
        this.mapWidth -= departureListWidth - 5.0f;
        this.departureBoardY = ((float)this.field_22790 - ((float)Texture.DESTINATION_LIST.height() * this.currentTextureScale + (float)(Texture.TRAVEL_BUTTON.height() / 2) * this.currentTextureScale)) / 2.0f;
        this.scrollButtonRenderX = 5.0f + departureListWidth * 0.933f;
        this.destinationButtonsRenderX = 5.0f + departureListWidth * 0.027f;
        this.scrollAreaHeight = (int)(220.0f * this.currentTextureScale);
        this.method_37063((class_364)new BasicTexturedButton((int)((float)(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 7 + 60) + departureListWidth / 2.0f), (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 12, 16, Texture.WAYPOINT_MANAGER_ICON, b -> this.toggleRoutes(), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showRoutes.name")), class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showRoutes.description").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new BasicTexturedButton((int)((float)(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6 + 40) + departureListWidth / 2.0f), (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 14, 14, Texture.ADD_ICON, b -> this.toggleDestinations(), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showInaccessibleLocations.name")), class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showInaccessibleLocations.description").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new BasicTexturedButton((int)((float)(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 5 + 20) + departureListWidth / 2.0f), (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 8.0f), 16, 16, Texture.OVERLAY_EXTRA_ICON, b -> this.toggleBorders(), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showBorders.name")), class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.showBorders.description").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new BasicTexturedButton((int)((float)(this.field_22789 / 2 - Texture.MAP_BUTTONS_BACKGROUND.width() / 2 + 6) + departureListWidth / 2.0f), (int)(this.renderHeight - this.renderedBorderYOffset - (float)(Texture.MAP_BUTTONS_BACKGROUND.height() / 2) - 7.0f), 15, 14, Texture.BOAT_ICON, b -> Models.Seaskipper.purchaseBoat(), List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.buyBoat.name")), class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.buyBoat.description").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new SeaskipperTravelButton(5, (int)(this.departureBoardY + (float)Texture.DESTINATION_LIST.height() * this.currentTextureScale), (int)((float)Texture.TRAVEL_BUTTON.width() * this.currentTextureScale), (int)((float)(Texture.TRAVEL_BUTTON.height() / 2) * this.currentTextureScale), this));
        if (this.firstInit) {
            this.centerMapAroundPlayer();
            this.setZoomLevel(20.0f);
            this.reloadDestinationPois();
            this.firstInit = false;
        }
        this.reloadButtons();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        this.renderMap(guiGraphics);
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        this.renderPois(poseStack, mouseX, mouseY);
        this.renderCursor(poseStack, 1.5f, (CustomColor)Managers.Feature.getFeatureInstance(CustomSeaskipperScreenFeature.class).pointerColor.get(), (PointerType)((Object)Managers.Feature.getFeatureInstance(CustomSeaskipperScreenFeature.class).pointerType.get()));
        RenderUtils.disableScissor(guiGraphics);
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCoordinates(poseStack, mouseX, mouseY);
        this.renderMapButtons(guiGraphics, mouseX, mouseY, partialTick);
        this.renderHoveredSeaskipperDestination(poseStack);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.DESTINATION_LIST.resource(), 5.0f, this.departureBoardY, 0.0f, (float)Texture.DESTINATION_LIST.width() * this.currentTextureScale, (float)Texture.DESTINATION_LIST.height() * this.currentTextureScale, Texture.DESTINATION_LIST.width(), Texture.DESTINATION_LIST.height());
        this.renderScrollButton(poseStack);
        for (SeaskipperDestinationButton destinationButton : this.destinationButtons) {
            destinationButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void method_25419() {
        McUtils.player().method_7346();
        super.method_25419();
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25405(mouseX, mouseY)) continue;
            child.method_25402(mouseX, mouseY, button);
            return true;
        }
        for (SeaskipperDestinationPoi poi : this.destinationPois) {
            if (this.hoveredPoi != poi) continue;
            if (poi.isAvailable()) {
                Models.Seaskipper.purchasePass(poi.getDestination());
            }
            return true;
        }
        for (SeaskipperDestinationButton destinationButton : this.destinationButtons) {
            if (destinationButton.method_49606() && this.selectedPoi != destinationButton.getDestination()) {
                this.selectedPoi = destinationButton.getDestination();
                this.zoomToDestination(this.selectedPoi);
                return true;
            }
            if (!destinationButton.method_49606() || this.selectedPoi != destinationButton.getDestination()) continue;
            Models.Seaskipper.purchasePass(destinationButton.getDestination().getDestination());
            return true;
        }
        if (!this.draggingScroll && this.availablePois.size() > 10 && MathUtils.isInside((int)mouseX, (int)mouseY, (int)this.scrollButtonRenderX, (int)(this.scrollButtonRenderX + (float)Texture.SCROLL_BUTTON.width() * this.currentTextureScale), (int)this.scrollButtonRenderY, (int)(this.scrollButtonRenderY + (float)Texture.SCROLL_BUTTON.height() * this.currentTextureScale))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int startRenderY = (int)(this.departureBoardY + 4.0f * this.currentTextureScale * 0.933f);
            int scrollAreaStartY = startRenderY + 9;
            int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, (float)(scrollAreaStartY + this.scrollAreaHeight) - (float)Texture.SCROLL_BUTTON.height() * this.currentTextureScale, 0.0f, Math.max(0, this.availablePois.size() - 10)));
            this.scroll(newValue - this.scrollOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.renderX) {
            return super.method_25401(mouseX, mouseY, deltaX, deltaY);
        }
        if (Math.abs(deltaY) == 1.0) {
            this.scroll((int)(-deltaY));
            return true;
        }
        this.currentUnusedScroll -= deltaY / 5.0;
        if (Math.abs(this.currentUnusedScroll) < 1.0) {
            return true;
        }
        int scroll = (int)this.currentUnusedScroll;
        this.currentUnusedScroll %= 1.0;
        this.scroll(scroll);
        return true;
    }

    public void reloadDestinationPois() {
        this.destinationPois = new ArrayList<SeaskipperDestinationPoi>();
        this.destinationPois.addAll(Models.Seaskipper.getPois(this.renderAllDestinations));
        this.currentLocationPoi = this.destinationPois.stream().filter(SeaskipperDestinationPoi::isPlayerInside).findFirst().orElse(null);
        this.availablePois = this.destinationPois.stream().filter(SeaskipperDestinationPoi::isAvailable).sorted(Comparator.comparing(SeaskipperDestinationPoi::getName, String.CASE_INSENSITIVE_ORDER)).toList();
        this.reloadButtons();
    }

    public void travelToDestination() {
        if (this.selectedPoi == null) {
            return;
        }
        Models.Seaskipper.purchasePass(this.selectedPoi.getDestination());
    }

    public SeaskipperDestinationPoi getSelectedDestination() {
        return this.selectedPoi;
    }

    private void renderPois(class_4587 poseStack, int mouseX, int mouseY) {
        this.renderDestinations(this.destinationPois, poseStack, BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.field_22789 / this.zoomRenderScale, (float)this.field_22790 / this.zoomRenderScale), 1.0f, mouseX, mouseY);
    }

    private void renderDestinations(List<SeaskipperDestinationPoi> pois, class_4587 poseStack, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        this.hoveredPoi = null;
        List<SeaskipperDestinationPoi> filteredPois = this.getRenderedDestinations(pois, textureBoundingBox, poiScale, mouseX, mouseY);
        if (this.renderRoutes) {
            float poiRenderX = MapRenderer.getRenderX(this.currentLocationPoi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(this.currentLocationPoi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            for (SeaskipperDestinationPoi poi : this.destinationPois.stream().filter(SeaskipperDestinationPoi::isAvailable).toList()) {
                float x = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
                float z = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
                RenderUtils.drawLine(poseStack, CommonColors.DARK_GRAY.withAlpha(0.5f), poiRenderX, poiRenderZ, x, z, 0.0f, 1.0f);
            }
        }
        class_4597.class_4598 bufferSource = McUtils.mc().method_22940().method_23000();
        for (int i = filteredPois.size() - 1; i >= 0; --i) {
            SeaskipperDestinationPoi poi = filteredPois.get(i);
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            if (this.hideTerritoryBorders) {
                poi.renderAtWithoutBorders(poseStack, (class_4597)bufferSource, poiRenderX, poiRenderZ, this.zoomRenderScale);
                continue;
            }
            poi.renderAt(poseStack, (class_4597)bufferSource, poiRenderX, poiRenderZ, this.hoveredPoi == poi, poiScale, this.zoomRenderScale, this.zoomLevel, true);
        }
        bufferSource.method_22993();
    }

    private List<SeaskipperDestinationPoi> getRenderedDestinations(List<SeaskipperDestinationPoi> pois, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        ArrayList<SeaskipperDestinationPoi> filteredPois = new ArrayList<SeaskipperDestinationPoi>();
        for (int i = pois.size() - 1; i >= 0; --i) {
            SeaskipperDestinationPoi poi = pois.get(i);
            PoiLocation location = poi.getLocation();
            if (location == null) continue;
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            float poiWidth = poi.getWidth(this.zoomRenderScale, poiScale);
            float poiHeight = poi.getHeight(this.zoomRenderScale, poiScale);
            BoundingBox filterBox = BoundingBox.centered(location.getX(), location.getZ(), poiWidth, poiHeight);
            BoundingBox mouseBox = BoundingBox.centered(poiRenderX, poiRenderZ, poiWidth, poiHeight);
            if (!BoundingShape.intersects(filterBox, textureBoundingBox)) continue;
            filteredPois.add(poi);
            if (this.hoveredPoi != null || !mouseBox.contains(mouseX, mouseY)) continue;
            this.hoveredPoi = poi;
        }
        if (this.hoveredPoi != null) {
            filteredPois.remove(this.hoveredPoi);
            filteredPois.addFirst(this.hoveredPoi);
        }
        return filteredPois;
    }

    private void renderHoveredSeaskipperDestination(class_4587 poseStack) {
        boolean origin;
        if (this.hoveredPoi == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 101.0f);
        int xOffset = (int)((float)this.field_22789 - 10.0f - 250.0f);
        int yOffset = 50;
        boolean isAccessible = this.hoveredPoi.isAvailable();
        float centerHeight = isAccessible ? 50.0f : 30.0f;
        int textureWidth = Texture.MAP_INFO_TOOLTIP_CENTER.width();
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_TOP, xOffset, yOffset);
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_TOOLTIP_CENTER.resource(), xOffset, Texture.MAP_INFO_TOOLTIP_TOP.height() + yOffset, textureWidth, centerHeight, textureWidth, Texture.MAP_INFO_TOOLTIP_CENTER.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_INFO_NAME_BOX, xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.level", (Object[])new Object[]{this.hoveredPoi.getLevel()})), 10 + xOffset, 10 + yOffset, CommonColors.ORANGE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        float renderYOffset = 10 + yOffset;
        boolean bl = origin = this.hoveredPoi == this.currentLocationPoi;
        if (isAccessible) {
            class_5250 travelComponent;
            CustomColor priceColor;
            int price = this.hoveredPoi.getDestination().item().getPrice();
            if (Models.Emerald.getAmountInInventory() >= this.hoveredPoi.getDestination().item().getPrice()) {
                priceColor = CommonColors.GREEN;
                travelComponent = class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.clickToGo");
            } else {
                priceColor = CommonColors.RED;
                travelComponent = class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.cannotAfford");
            }
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43469((String)"screens.wynntils.customSeaskipperScreen.cost", (Object[])new Object[]{price})), 10 + xOffset, 10.0f + (renderYOffset += 10.0f), priceColor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)travelComponent), 10 + xOffset, 10.0f + (renderYOffset += 20.0f), CommonColors.LIGHT_BLUE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        } else if (origin) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.origin")), 10 + xOffset, 10.0f + (renderYOffset += 10.0f), CommonColors.ORANGE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        } else {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.customSeaskipperScreen.inaccessible")), 10 + xOffset, 10.0f + (renderYOffset += 10.0f), CommonColors.GRAY, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(this.hoveredPoi.getName()), 7 + xOffset, textureWidth + xOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)Texture.MAP_INFO_NAME_BOX.height() + (float)yOffset, 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
        poseStack.method_22909();
    }

    private void renderScrollButton(class_4587 poseStack) {
        if (this.availablePois.size() <= 10) {
            return;
        }
        this.scrollButtonRenderY = (float)((int)(this.departureBoardY + 4.0f * this.currentTextureScale * 0.933f)) + MathUtils.map(this.scrollOffset, 0.0f, this.availablePois.size() - 10, 0.0f, (float)this.scrollAreaHeight - (float)Texture.SCROLL_BUTTON.height() * this.currentTextureScale);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.SCROLL_BUTTON.resource(), this.scrollButtonRenderX, this.scrollButtonRenderY, 0.0f, (float)Texture.SCROLL_BUTTON.width() * this.currentTextureScale, (float)Texture.SCROLL_BUTTON.height() * this.currentTextureScale, Texture.SCROLL_BUTTON.width(), Texture.SCROLL_BUTTON.height());
    }

    private void scroll(int delta) {
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, Math.max(0, this.availablePois.size() - 10));
        this.reloadButtons();
    }

    private void zoomToDestination(SeaskipperDestinationPoi destination) {
        this.updateMapCenter(destination.getLocation().getX(), destination.getLocation().getZ());
        this.setZoomLevel(20.0f);
    }

    private void reloadButtons() {
        int n;
        for (class_339 class_3392 : this.destinationButtons) {
            this.method_37066((class_364)class_3392);
        }
        this.destinationButtons = new ArrayList<SeaskipperDestinationButton>();
        int buttonY = (int)(this.departureBoardY + 4.0f * this.currentTextureScale * 0.933f);
        int buttonHeight = (int)((float)(Texture.DESTINATION_BUTTON.height() / 2) * this.currentTextureScale);
        int totalGapSpace = this.scrollAreaHeight - buttonHeight * 10;
        int buttonOffset = totalGapSpace / 9;
        for (int i = 0; i < 10 && (n = i + this.scrollOffset) <= this.availablePois.size() - 1; ++i) {
            if (!this.availablePois.get(n).isAvailable()) continue;
            SeaskipperDestinationButton button = new SeaskipperDestinationButton((int)this.destinationButtonsRenderX, buttonY, (int)((float)Texture.DESTINATION_BUTTON.width() * this.currentTextureScale), buttonHeight, this.availablePois.get(n), this);
            this.destinationButtons.add(button);
            buttonY += (int)((float)(Texture.DESTINATION_BUTTON.height() / 2) * this.currentTextureScale) + buttonOffset;
        }
    }

    private void toggleBorders() {
        this.hideTerritoryBorders = !this.hideTerritoryBorders;
    }

    private void toggleDestinations() {
        this.renderAllDestinations = !this.renderAllDestinations;
        this.reloadDestinationPois();
    }

    private void toggleRoutes() {
        this.renderRoutes = !this.renderRoutes;
    }
}

