/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.google.common.collect.Lists;
import com.wynntils.screens.maps.IconFilterScreen;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class IconFilterWidget
extends class_339 {
    private final boolean included;
    private final float iconHeight;
    private final float iconRenderX;
    private final float iconRenderY;
    private final float iconWidth;
    private final List<class_2561> tooltip;
    private final IconFilterScreen filterScreen;
    private final Texture icon;

    public IconFilterWidget(int x, int y, int width, int height, Texture icon, IconFilterScreen filterScreen, boolean included) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Icon Filter Widget"));
        this.icon = icon;
        this.filterScreen = filterScreen;
        this.included = included;
        float scaleFactor = 0.5f * (float)Math.min(width, height) / (float)Math.max(icon.width(), icon.height());
        this.iconWidth = (float)icon.width() * scaleFactor;
        this.iconHeight = (float)icon.height() * scaleFactor;
        this.iconRenderX = (float)x + (float)width / 2.0f - this.iconWidth / 2.0f;
        this.iconRenderY = (float)y + (float)height / 2.0f - this.iconHeight / 2.0f;
        this.tooltip = included ? List.of(class_2561.method_43469((String)"screens.wynntils.iconFilter.filterExclude.tooltip", (Object[])new Object[]{EnumUtils.toNiceString(icon)})) : List.of(class_2561.method_43469((String)"screens.wynntils.iconFilter.filterInclude.tooltip", (Object[])new Object[]{EnumUtils.toNiceString(icon)}));
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawRect(poseStack, CommonColors.BLACK.withAlpha(this.field_22762 ? 0.7f : 0.5f), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        RenderUtils.drawScalingTexturedRect(poseStack, this.icon.resource(), this.iconRenderX, this.iconRenderY, 1.0f, this.iconWidth, this.iconHeight, this.icon.width(), this.icon.height());
        if (this.field_22762) {
            McUtils.mc().field_1755.method_47414(Lists.transform(this.tooltip, class_2561::method_30937));
        }
        if (this.included) {
            RenderUtils.drawRect(poseStack, CommonColors.RED.withAlpha(35), this.method_46426(), this.method_46427(), 1.0f, this.field_22758, this.field_22759);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        this.filterScreen.toggleIcon(this.icon);
        return true;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

