/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.overlays.selection;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import com.wynntils.features.overlays.CustomBarsOverlayFeature;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.BarTexture;
import com.wynntils.utils.render.type.HealthTexture;
import com.wynntils.utils.render.type.ManaTexture;
import com.wynntils.utils.render.type.ObjectivesTextures;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.type.Pair;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7919;

public final class CustomBarSelectionScreen
extends WynntilsScreen {
    private static final List<Pair<Texture, List<BarTexture>>> availableBars = List.of(Pair.of(Texture.UNIVERSAL_BAR, List.of(UniversalTexture.values())), Pair.of(Texture.HEALTH_BAR, List.of(HealthTexture.values())), Pair.of(Texture.MANA_BAR, List.of(ManaTexture.values())), Pair.of(Texture.EXPERIENCE_BAR, List.of(ObjectivesTextures.values())), Pair.of(Texture.BUBBLE_BAR, List.of(ObjectivesTextures.values())));
    private final OverlaySelectionScreen previousScreen;
    private class_4185 textureButton;
    private float barX;
    private float barY;
    private int barTextureIndex = 0;
    private int barTypeIndex = 0;

    private CustomBarSelectionScreen(OverlaySelectionScreen previousScreen) {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.customBarSelection.name"));
        this.previousScreen = previousScreen;
    }

    public static class_437 create(OverlaySelectionScreen previousScreen) {
        return new CustomBarSelectionScreen(previousScreen);
    }

    @Override
    protected void doInit() {
        this.calculateBarPosition();
        this.textureButton = (class_4185)this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43470((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()), b -> {}).method_46433((int)((float)this.field_22789 / 2.0f - 30.0f), (int)(this.barY + 20.0f)).method_46437(60, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.customBarSelection.textureTooltip"))).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1c"), button -> this.scrollBars(-1)).method_46433((int)((float)this.field_22789 / 2.0f) - 120, (int)(this.barY + 45.0f)).method_46437(20, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.customBarSelection.cancel"), button -> this.method_25419()).method_46433((int)((float)this.field_22789 / 2.0f) - 90, (int)(this.barY + 45.0f)).method_46437(80, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.customBarSelection.select"), button -> this.addCustomBar()).method_46433((int)((float)this.field_22789 / 2.0f) + 10, (int)(this.barY + 45.0f)).method_46437(80, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1e"), button -> this.scrollBars(1)).method_46433((int)((float)this.field_22789 / 2.0f) + 100, (int)(this.barY + 45.0f)).method_46437(20, 20).method_46431());
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        BufferedRenderUtils.drawProgressBar(poseStack, (class_4597)guiGraphics.field_44658, availableBars.get(this.barTypeIndex).a(), this.barX, this.barY, this.barX + (float)availableBars.get(this.barTypeIndex).a().width(), this.barY + (float)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getHeight(), 0, availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getTextureY1(), availableBars.get(this.barTypeIndex).a().width(), availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getTextureY2(), 0.5f);
    }

    public void method_25419() {
        McUtils.mc().method_1507((class_437)this.previousScreen);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            if (listener == this.textureButton) {
                if (button == 0) {
                    this.scrollTextures(1);
                    McUtils.playSoundUI((class_3414)class_3417.field_15015.comp_349());
                    return true;
                }
                if (button == 1) {
                    this.scrollTextures(-1);
                    McUtils.playSoundUI((class_3414)class_3417.field_15015.comp_349());
                    return true;
                }
                return false;
            }
            return listener.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scrollBars((int)scrollValue);
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void calculateBarPosition() {
        this.barX = (float)(this.field_22789 - availableBars.get(this.barTypeIndex).a().width()) / 2.0f;
        this.barY = (float)(this.field_22790 - availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).getHeight()) / 2.0f;
    }

    private void scrollBars(int direction) {
        this.barTypeIndex = this.barTypeIndex + direction > availableBars.size() - 1 ? 0 : (this.barTypeIndex + direction < 0 ? availableBars.size() - 1 : (this.barTypeIndex += direction));
        this.barTextureIndex = 0;
        this.textureButton.method_25355((class_2561)class_2561.method_43470((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()));
        this.calculateBarPosition();
    }

    private void scrollTextures(int direction) {
        this.barTextureIndex = this.barTextureIndex + direction > availableBars.get(this.barTypeIndex).b().size() - 1 ? 0 : (this.barTextureIndex + direction < 0 ? availableBars.get(this.barTypeIndex).b().size() - 1 : (this.barTextureIndex += direction));
        this.textureButton.method_25355((class_2561)class_2561.method_43470((String)availableBars.get(this.barTypeIndex).b().get(this.barTextureIndex).toString()));
        this.calculateBarPosition();
    }

    private void addCustomBar() {
        CustomBarsOverlayFeature customBarsFeature = Managers.Feature.getFeatureInstance(CustomBarsOverlayFeature.class);
        List<OverlayGroupHolder> groupHolders = Managers.Overlay.getFeatureOverlayGroups(customBarsFeature);
        OverlayGroupHolder barGroup = groupHolders.get(this.barTypeIndex);
        int id = Managers.Overlay.extendOverlayGroup(barGroup);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        this.previousScreen.populateOverlays();
        this.previousScreen.selectOverlay(barGroup.getOverlays().getLast());
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.overlaySelection.createdOverlay", (Object[])new Object[]{barGroup.getOverlayClass().getSimpleName(), barGroup.getFieldName(), id}).method_27692(class_124.field_1060));
        this.method_25419();
    }
}

