/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.Configurable;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.CustomNameProperty;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ConfigurableButton
extends WynntilsButton {
    private final Configurable configurable;
    private final WynntilsCheckbox enabledCheckbox;
    private final int maskTopY;
    private final int maskBottomY;
    private final int matchingConfigs;
    private final List<class_2561> descriptionTooltip;
    private final List<class_2561> toggleTooltip;
    private final WynntilsBookSettingsScreen settingsScreen;

    public ConfigurableButton(int x, int y, int width, int height, Configurable configurable, WynntilsBookSettingsScreen screen, int matchingConfigs) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)configurable.getTranslatedName()));
        this.configurable = configurable;
        this.settingsScreen = screen;
        if (configurable instanceof Feature) {
            Feature feature = (Feature)configurable;
            this.descriptionTooltip = ComponentUtils.wrapTooltips(List.of(class_2561.method_43470((String)feature.getTranslatedDescription())), 150);
            this.toggleTooltip = ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.settingsScreen.toggleFeature", (Object[])new Object[]{configurable.getTranslatedName()})), 150);
        } else {
            this.descriptionTooltip = List.of();
            this.toggleTooltip = ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.settingsScreen.toggleOverlay", (Object[])new Object[]{configurable.getTranslatedName()})), 150);
        }
        boolean enabled = false;
        if (configurable instanceof Overlay) {
            Overlay selectedOverlay = (Overlay)configurable;
            enabled = Managers.Overlay.isEnabled(selectedOverlay);
        } else if (configurable instanceof Feature) {
            Feature selectedFeature = (Feature)configurable;
            enabled = selectedFeature.isEnabled();
        }
        this.enabledCheckbox = new WynntilsCheckbox(x + width - 10, y, 10, (class_2561)class_2561.method_43470((String)""), enabled, 0);
        this.maskTopY = this.settingsScreen.getMaskTopY();
        this.maskBottomY = this.settingsScreen.getConfigurableMaskBottomY();
        this.matchingConfigs = matchingConfigs;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        CustomNameProperty customNameProperty;
        WynntilsBookSettingsScreen bookSettingsScreen;
        class_4587 poseStack = guiGraphics.method_51448();
        if (this.field_22762 && (mouseY <= this.maskTopY || mouseY >= this.maskBottomY)) {
            this.field_22762 = false;
        }
        CustomColor color = this.field_22762 ? CommonColors.YELLOW : CommonColors.WHITE;
        class_437 class_4372 = McUtils.mc().field_1755;
        if (class_4372 instanceof WynntilsBookSettingsScreen && (bookSettingsScreen = (WynntilsBookSettingsScreen)class_4372).getSelectedConfigurable() == this.configurable) {
            color = CommonColors.GRAY;
        }
        boolean isOverlay = this.configurable instanceof Overlay;
        Object textToRender = this.configurable.getTranslatedName();
        Configurable configurable = this.configurable;
        if (configurable instanceof CustomNameProperty && !((String)(customNameProperty = (CustomNameProperty)((Object)configurable)).getCustomName().get()).isEmpty()) {
            textToRender = (String)customNameProperty.getCustomName().get();
        }
        if (this.matchingConfigs > 0) {
            textToRender = (String)textToRender + String.valueOf(class_124.field_1080) + " [" + this.matchingConfigs + "]";
        }
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString((String)textToRender), isOverlay ? this.method_46426() + 12 : this.method_46426(), this.method_46427(), (isOverlay ? this.field_22758 - 12 : this.field_22758) - 11, color, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
        this.enabledCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.field_22762) {
            if (this.enabledCheckbox.method_49606()) {
                McUtils.mc().field_1755.method_47414(Lists.transform(this.toggleTooltip, class_2561::method_30937));
            } else if (this.configurable instanceof Feature) {
                McUtils.mc().field_1755.method_47414(Lists.transform(this.descriptionTooltip, class_2561::method_30937));
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        if (this.enabledCheckbox.method_25405(mouseX, mouseY)) {
            Configurable configurable = this.configurable;
            if (configurable instanceof Feature) {
                Feature feature;
                feature.setUserEnabled(!(feature = (Feature)configurable).isEnabled());
            } else if (this.configurable instanceof Overlay) {
                Optional<Config<?>> configOpt = this.configurable.getConfigOptionFromString("userEnabled");
                if (configOpt.isPresent()) {
                    Config<?> config;
                    config.setValue((Boolean)(config = configOpt.get()).get() == false);
                } else {
                    return false;
                }
            }
            configurable = McUtils.mc().field_1755;
            if (configurable instanceof WynntilsBookSettingsScreen) {
                WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)((Object)configurable);
                bookSettingsScreen.populateConfigurables();
                bookSettingsScreen.changesMade();
            }
            return this.enabledCheckbox.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25306() {
        class_437 class_4372 = McUtils.mc().field_1755;
        if (class_4372 instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)class_4372;
            bookSettingsScreen.setSelectedConfigurable(this.configurable);
        }
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.enabledCheckbox.method_46419(y);
    }

    public Configurable getConfigurable() {
        return this.configurable;
    }
}

