/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets.quickfilters;

import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.screens.territorymanagement.widgets.quickfilters.TerritoryQuickFilterWidget;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.statproviders.territory.TerritoryProductionStatProvider;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TerritoryProducesQuickFilterWidget
extends TerritoryQuickFilterWidget {
    private static final List<GuildResource> POSSIBLE_RESOURCES = Arrays.stream(GuildResource.values()).filter(GuildResource::isMaterialResource).toList();
    private GuildResource resource = null;

    public TerritoryProducesQuickFilterWidget(int x, int y, int width, int height, TerritoryManagementScreen screen) {
        super(x, y, width, height, screen);
    }

    @Override
    protected void forwardClick() {
        int index;
        this.resource = this.resource == null ? POSSIBLE_RESOURCES.getFirst() : ((index = POSSIBLE_RESOURCES.indexOf((Object)this.resource) + 1) >= POSSIBLE_RESOURCES.size() ? null : POSSIBLE_RESOURCES.get(index));
    }

    @Override
    protected void backwardClick() {
        int index;
        this.resource = this.resource == null ? POSSIBLE_RESOURCES.getLast() : ((index = POSSIBLE_RESOURCES.indexOf((Object)this.resource) - 1) < 0 ? null : POSSIBLE_RESOURCES.get(index));
    }

    @Override
    protected void resetClick() {
        this.resource = null;
    }

    @Override
    protected class_5250 getFilterName() {
        return class_2561.method_43470((String)("Produces: " + (this.resource == null ? "-" : this.resource.getName())));
    }

    @Override
    protected CustomColor getFilterColor() {
        return this.resource == null ? CommonColors.GRAY : CustomColor.fromChatFormatting(this.resource.getColor());
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        if (this.resource == null) {
            return List.of();
        }
        return List.of(new StatProviderAndFilterPair<Integer>(new TerritoryProductionStatProvider(this.resource), new AnyStatFilters.AnyIntegerStatFilter()));
    }
}

