/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets.quicksorts;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public abstract class TerritoryQuickSortWidget
extends class_339 {
    private final TerritoryManagementScreen screen;
    protected SortDirection sortDirection = null;

    protected TerritoryQuickSortWidget(int x, int y, int width, int height, TerritoryManagementScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.screen = screen;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean isHovered = this.method_25405(mouseX, mouseY);
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43470((String)this.getSortName()).method_27692(isHovered ? class_124.field_1067 : class_124.field_1070).method_27693(" ").method_27693(this.sortDirection == null ? "-" : (this.sortDirection == SortDirection.ASCENDING ? "\u25b2" : "\u25bc"))), this.method_46426() + 5, this.method_46427() + 5, this.getSortColor(), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked;
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        if (this.method_25351(button) && (clicked = this.method_25405(mouseX, mouseY))) {
            this.method_25354(class_310.method_1551().method_1483());
            if (button == 0) {
                this.forwardClick();
            } else if (button == 1) {
                this.backwardClick();
            } else if (button == 2) {
                this.resetClick();
            }
            this.screen.updateSearchFromQuickFilters();
            return true;
        }
        return false;
    }

    protected boolean method_25351(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    public final String getItemSearchQuery() {
        if (this.sortDirection == null) {
            return "";
        }
        return Services.ItemFilter.getItemFilterString(Map.of(), this.getSortInfos(), List.of());
    }

    private void forwardClick() {
        this.sortDirection = this.sortDirection == null ? SortDirection.ASCENDING : (this.sortDirection == SortDirection.ASCENDING ? SortDirection.DESCENDING : null);
    }

    private void backwardClick() {
        this.sortDirection = this.sortDirection == null ? SortDirection.DESCENDING : (this.sortDirection == SortDirection.DESCENDING ? SortDirection.ASCENDING : null);
    }

    private void resetClick() {
        this.sortDirection = null;
    }

    protected abstract String getSortName();

    protected abstract CustomColor getSortColor();

    protected abstract List<SortInfo> getSortInfos();
}

