/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.athena;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.net.event.DownloadEvent;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.services.athena.type.ChangelogMap;
import com.wynntils.services.athena.type.ModUpdateInfo;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.minecraft.class_155;
import net.neoforged.bus.api.SubscribeEvent;

public final class UpdateService
extends Service {
    private static final String WYNNTILS_UPDATE_FOLDER = "updates";
    private static final String WYNNTILS_UPDATE_FILE_NAME = "wynntils-update.jar";
    private static final File UPDATES_FOLDER = WynntilsMod.getModStorageDir("updates");
    @Persisted
    public final Storage<String> lastShownChangelogVersion = new Storage<String>(WynntilsMod.getVersion());
    @Persisted
    public final Storage<String> ignoredUpdate = new Storage<String>("");
    private boolean promptedUpdate = false;
    private float updateProgress = -1.0f;
    private ModUpdateInfo modUpdateInfo;

    public UpdateService() {
        super(List.of());
    }

    @SubscribeEvent
    public void onDownloadsFinished(DownloadEvent.Completed event) {
        this.getLatestBuild().thenAccept(updateInfo -> {
            this.modUpdateInfo = updateInfo;
        });
    }

    public CompletableFuture<ModUpdateInfo> getLatestBuild() {
        if (WynntilsMod.isDevelopmentEnvironment()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ModUpdateInfo> future = new CompletableFuture<ModUpdateInfo>();
        String stream = this.getStream();
        WynntilsMod.info("Checking for update for stream " + stream + ".");
        ApiResponse apiResponse = Services.WynntilsAccount.callApi(UrlId.API_ATHENA_UPDATE_CHECK, Map.of("stream", stream));
        apiResponse.handleJsonObject(json -> {
            ModUpdateInfo version = (ModUpdateInfo)JsonManager.GSON.fromJson((JsonElement)json, ModUpdateInfo.class);
            if (this.checkUpdateIsValid(version)) {
                this.modUpdateInfo = version;
                future.complete(version);
            } else {
                future.complete(null);
            }
        }, onError -> {
            WynntilsMod.error("Exception while trying to fetch update.");
            future.complete(null);
        });
        return future;
    }

    public CompletableFuture<UpdateResult> tryUpdate() {
        CompletableFuture<UpdateResult> future = new CompletableFuture<UpdateResult>();
        if (this.modUpdateInfo == null) {
            String stream = this.getStream();
            WynntilsMod.info("Attempting to download update for stream " + stream + ".");
            ApiResponse apiResponse = Services.WynntilsAccount.callApi(UrlId.API_ATHENA_UPDATE_CHECK, Map.of("stream", stream));
            apiResponse.handleJsonObject(json -> {
                ModUpdateInfo updateInfo = (ModUpdateInfo)JsonManager.GSON.fromJson((JsonElement)json, ModUpdateInfo.class);
                if (updateInfo.md5() == null) {
                    future.complete(UpdateResult.ERROR);
                    return;
                }
                String currentMd5 = FileUtils.getMd5(WynntilsMod.getModJar());
                if (Objects.equals(currentMd5, updateInfo.md5())) {
                    future.complete(UpdateResult.ALREADY_ON_LATEST);
                    return;
                }
                if (!Objects.equals(updateInfo.supportedMcVersion(), class_155.method_16673().method_48019())) {
                    future.complete(UpdateResult.INCORRECT_VERSION_RECEIVED);
                    return;
                }
                File localUpdateFile = this.getUpdateFile();
                if (localUpdateFile.exists()) {
                    String localUpdateMd5 = FileUtils.getMd5(localUpdateFile);
                    if (Objects.equals(localUpdateMd5, updateInfo.md5())) {
                        future.complete(UpdateResult.UPDATE_PENDING);
                        return;
                    }
                    FileUtils.deleteFile(localUpdateFile);
                }
                this.tryFetchNewUpdate(updateInfo, future);
            }, onError -> {
                WynntilsMod.error("Exception while trying to load new update.");
                future.complete(UpdateResult.ERROR);
            });
        } else {
            File localUpdateFile = this.getUpdateFile();
            if (localUpdateFile.exists()) {
                String localUpdateMd5 = FileUtils.getMd5(localUpdateFile);
                if (Objects.equals(localUpdateMd5, this.modUpdateInfo.md5())) {
                    future.complete(UpdateResult.UPDATE_PENDING);
                    return future;
                }
                FileUtils.deleteFile(localUpdateFile);
            }
            Executors.newSingleThreadExecutor().submit(() -> this.tryFetchNewUpdate(this.modUpdateInfo, future));
        }
        return future;
    }

    public CompletableFuture<ChangelogMap> getChangelog(boolean saveLastShown) {
        return this.getChangelog((String)this.lastShownChangelogVersion.get(), WynntilsMod.getVersion(), saveLastShown);
    }

    public CompletableFuture<ChangelogMap> getChangelog(String oldVersion, String newVersion, boolean saveLastShown) {
        CompletableFuture<ChangelogMap> future = new CompletableFuture<ChangelogMap>();
        ApiResponse response = Services.WynntilsAccount.callApi(UrlId.API_ATHENA_UPDATE_CHANGELOG_V2, Map.of("old_version", oldVersion, "new_version", newVersion));
        response.handleJsonObject(jsonObject -> {
            if (!jsonObject.has("changelogs")) {
                return;
            }
            if (saveLastShown) {
                this.lastShownChangelogVersion.store(WynntilsMod.getVersion());
            }
            JsonObject changelogs = jsonObject.getAsJsonObject("changelogs");
            LinkedHashMap<String, String> changelogMap = new LinkedHashMap<String, String>();
            ArrayList entries = new ArrayList(changelogs.entrySet());
            for (int i = entries.size() - 1; i >= 0; --i) {
                Map.Entry versionEntry = (Map.Entry)entries.get(i);
                changelogMap.put((String)versionEntry.getKey(), ((JsonElement)versionEntry.getValue()).getAsString());
            }
            future.complete(new ChangelogMap(changelogMap));
        }, throwable -> WynntilsMod.warn("Could not get update changelog: ", throwable));
        return future;
    }

    public boolean shouldPromptUpdate() {
        return !this.promptedUpdate && this.modUpdateInfo != null && !this.modUpdateInfo.version().equals(this.ignoredUpdate.get());
    }

    public void setHasPromptedUpdate(boolean promptedUpdate) {
        this.promptedUpdate = promptedUpdate;
    }

    public float getUpdateProgress() {
        return this.updateProgress;
    }

    public ModUpdateInfo getModUpdateInfo() {
        return this.modUpdateInfo;
    }

    public File getUpdatesFolder() {
        return UPDATES_FOLDER;
    }

    private File getUpdateFile() {
        File updatesDir = new File(UPDATES_FOLDER.toURI());
        FileUtils.mkdir(updatesDir);
        return new File(updatesDir, WYNNTILS_UPDATE_FILE_NAME);
    }

    private String getStream() {
        String version = WynntilsMod.getVersion();
        if (WynntilsMod.isDevelopmentBuild()) {
            return "alpha";
        }
        String stream = version.replaceAll("v\\d+\\.\\d+\\.\\d+(-(?<stream>[a-z\\-]+)\\.\\d+)?(\\+MC-\\d\\.\\d+\\.\\d+)?", "${stream}");
        if (stream.isEmpty()) {
            return "release";
        }
        return stream;
    }

    private boolean checkUpdateIsValid(ModUpdateInfo updateInfo) {
        if (updateInfo.version() == null) {
            WynntilsMod.info("Couldn't fetch latest version, not attempting update reminder or auto-update.");
            return false;
        }
        if (Objects.equals(updateInfo.version(), WynntilsMod.getVersion())) {
            WynntilsMod.info("Mod is on latest version, not attempting update reminder or auto-update.");
            return false;
        }
        if (!Objects.equals(updateInfo.supportedMcVersion(), class_155.method_16673().method_48019())) {
            WynntilsMod.info("Athena sent an update for a different MC version, not attempting update reminder or auto-update.");
            return false;
        }
        return true;
    }

    private void tryFetchNewUpdate(ModUpdateInfo updateInfo, CompletableFuture<UpdateResult> future) {
        File oldJar = WynntilsMod.getModJar();
        File newJar = this.getUpdateFile();
        try {
            URL downloadUrl = URI.create(updateInfo.url()).toURL();
            URLConnection connection = downloadUrl.openConnection();
            FileUtils.downloadFileWithProgress(connection, newJar, progress -> {
                this.updateProgress = progress.floatValue();
            });
            this.updateProgress = -1.0f;
            String downloadedUpdateFileMd5 = FileUtils.getMd5(newJar);
            if (!Objects.equals(downloadedUpdateFileMd5, updateInfo.md5())) {
                newJar.delete();
                future.complete(UpdateResult.ERROR);
                WynntilsMod.error("Downloaded update file is corrupted!");
                return;
            }
            future.complete(UpdateResult.SUCCESSFUL);
            WynntilsMod.info("Successfully downloaded Wynntils update!");
            this.addShutdownHook(oldJar, newJar);
        }
        catch (IOException exception) {
            this.updateProgress = -1.0f;
            future.complete(UpdateResult.ERROR);
        }
    }

    private void addShutdownHook(File oldJar, File newJar) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (oldJar == null || !oldJar.exists() || oldJar.isDirectory()) {
                    WynntilsMod.warn("Mod jar file not found or incorrect.");
                    return;
                }
                FileUtils.copyFile(newJar, oldJar);
                newJar.delete();
                WynntilsMod.info("Successfully applied update!");
            }
            catch (IOException e) {
                WynntilsMod.error("Cannot apply update!", e);
            }
        }));
    }
}

