/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hint;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.services.hint.type.HintAction;
import com.wynntils.utils.mc.McUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_304;
import net.minecraft.class_5250;

public class HintService
extends Service {
    private static final String DEFAULT_LANGUAGE = "en_us";
    private static final String UNBOUND_KEY = "key.keyboard.unknown";
    private static final Random RANDOM = new Random();
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{(?<action>[^:}]+):(?<value>[^}]+)\\}");
    private List<Map<String, String>> hints = new ArrayList<Map<String, String>>();

    public HintService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_HINTS).handleReader(this::handleHintMessages);
    }

    private void handleHintMessages(Reader reader) {
        Type type = new TypeToken<List<Map<String, String>>>(){}.getType();
        this.hints = (List)WynntilsMod.GSON.fromJson(reader, type);
    }

    public void sendHint() {
        String languageCode = McUtils.mc().method_1526().method_4669();
        if (this.hints.isEmpty()) {
            return;
        }
        int hintNum = RANDOM.nextInt(this.hints.size());
        Map<String, String> currentHint = this.hints.get(hintNum);
        String hint = currentHint.containsKey(languageCode) ? currentHint.get(languageCode) : currentHint.getOrDefault(DEFAULT_LANGUAGE, "");
        if (hint.isEmpty()) {
            WynntilsMod.warn("Hint " + hintNum + " has no en_us translation.");
            return;
        }
        class_5250 component = this.formatHint(hint);
        if (component.equals((Object)class_2561.method_43473())) {
            return;
        }
        McUtils.sendMessageToClientWithPillHeader((class_2561)component);
    }

    private class_5250 formatHint(String hint) {
        StyledText styledText = StyledText.EMPTY;
        Matcher matcher = VARIABLE_PATTERN.matcher(hint);
        int lastEnd = 0;
        while (matcher.find()) {
            class_5250 actionComponent;
            String actionStr;
            HintAction hintAction;
            if (matcher.start() > lastEnd) {
                styledText = styledText.append(StyledText.fromComponent((class_2561)class_2561.method_43470((String)hint.substring(lastEnd, matcher.start()))));
            }
            if ((hintAction = HintAction.fromString(actionStr = matcher.group("action"))) == null) {
                WynntilsMod.warn("Unknown hint action " + actionStr);
                return class_2561.method_43473();
            }
            String value = matcher.group("value");
            switch (hintAction) {
                default: {
                    throw new MatchException(null, null);
                }
                case KEYBIND: {
                    class_5250 class_52502 = this.createKeybindPart(value);
                    break;
                }
                case TOGGLE_COMMAND: 
                case WYNNTILS_COMMAND: {
                    class_5250 class_52502 = actionComponent = this.createCommandPart(hintAction.name().toLowerCase(Locale.ROOT).replace("_command", ""), value);
                }
            }
            if (actionComponent.equals((Object)class_2561.method_43473())) {
                return class_2561.method_43473();
            }
            styledText = styledText.append(StyledText.fromComponent((class_2561)actionComponent));
            lastEnd = matcher.end();
        }
        if (lastEnd < hint.length()) {
            styledText = styledText.append(StyledText.fromComponent((class_2561)class_2561.method_43470((String)hint.substring(lastEnd))));
        }
        return styledText.getComponent().method_27692(class_124.field_1076);
    }

    private class_5250 createKeybindPart(String keybindName) {
        for (class_304 keyMapping : McUtils.options().field_1839) {
            if (!keyMapping.method_1431().equals(keybindName)) continue;
            String translated = keyMapping.method_16007().getString();
            if (translated.equals(class_1074.method_4662((String)UNBOUND_KEY, (Object[])new Object[0]))) {
                WynntilsMod.info("Skipping hint due to unbound key");
                return class_2561.method_43473();
            }
            return class_2561.method_43470((String)translated).method_27692(class_124.field_1054);
        }
        WynntilsMod.info("Skipping hint due to unknown keybind " + keybindName);
        return class_2561.method_43473();
    }

    private class_5250 createCommandPart(String command, String argument) {
        String fullCommand = "/" + command + " " + argument;
        return class_2561.method_43470((String)fullCommand).method_27694(style -> style.method_10977(class_124.field_1065).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, fullCommand)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to run " + fullCommand)))));
    }
}

