/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.features.LootrunFeature;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.type.BlockValidness;
import com.wynntils.services.lootrunpaths.type.ColoredPath;
import com.wynntils.services.lootrunpaths.type.ColoredPosition;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import com.wynntils.utils.render.buffered.CustomRenderType;
import com.wynntils.utils.type.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_9799;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class LootrunRenderer {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));

    public static void renderLootrun(class_4587 poseStack, LootrunPathInstance lootrun, int color) {
        if (lootrun == null) {
            return;
        }
        class_638 level = McUtils.mc().field_1687;
        if (level == null) {
            return;
        }
        poseStack.method_22903();
        class_4184 camera = McUtils.mc().field_1773.method_19418();
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        Long2ObjectMap<List<ColoredPath>> points = lootrun.points();
        int renderDistance = (Integer)McUtils.options().method_42503().method_41753();
        class_2338 pos = camera.method_19328();
        class_1923 origin = new class_1923(pos);
        for (int i = 0; i <= renderDistance; ++i) {
            for (int j = 0; j <= renderDistance; ++j) {
                int x = j + origin.field_9181 - renderDistance / 2;
                int z = i + origin.field_9180 - renderDistance / 2;
                class_1923 chunk = new class_1923(x, z);
                if (!level.method_8393(chunk.field_9181, chunk.field_9180)) continue;
                long chunkLong = chunk.method_8324();
                if (points.containsKey(chunkLong)) {
                    LootrunRenderer.renderPoints(poseStack, points, chunkLong);
                }
                if (lootrun.chests().containsKey(chunkLong)) {
                    LootrunRenderer.renderChests(poseStack, lootrun, color, chunkLong);
                }
                if (!((Boolean)Managers.Feature.getFeatureInstance(LootrunFeature.class).showNotes.get()).booleanValue() || !lootrun.notes().containsKey(chunkLong)) continue;
                LootrunRenderer.renderNotes(poseStack, lootrun, color, chunkLong);
            }
        }
        poseStack.method_22909();
    }

    private static void renderNotes(class_4587 poseStack, LootrunPathInstance lootrun, int color, long chunkLong) {
        List notes = (List)lootrun.notes().get(chunkLong);
        class_327 font = McUtils.mc().field_1772;
        for (LootrunNote note : notes) {
            class_2374 position = note.position();
            poseStack.method_22903();
            poseStack.method_22904(position.method_10216(), position.method_10214() + 2.0, position.method_10215());
            poseStack.method_22907(McUtils.mc().field_1773.method_19418().method_23767());
            poseStack.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f pose = poseStack.method_23760().method_23761();
            List lines = font.method_1728((class_5348)note.component(), 200);
            Objects.requireNonNull(font);
            int offsetY = -(9 * lines.size()) / 2;
            for (class_5481 line : lines) {
                int offsetX = -font.method_30880(line) / 2;
                font.method_22942(line, (float)offsetX, (float)offsetY, color, false, pose, (class_4597)BUFFER_SOURCE, class_327.class_6415.field_33993, Integer.MIN_VALUE, 0xF000F0);
                Objects.requireNonNull(font);
                offsetY += 9 + 2;
            }
            poseStack.method_22909();
        }
    }

    private static void renderChests(class_4587 poseStack, LootrunPathInstance lootrun, int color, long chunkLong) {
        class_4588 consumer = BUFFER_SOURCE.getBuffer(class_1921.method_23594());
        Set chests = (Set)lootrun.chests().get(chunkLong);
        float red = (float)class_9848.method_61327((int)color) / 255.0f;
        float green = (float)class_9848.method_61329((int)color) / 255.0f;
        float blue = (float)class_9848.method_61331((int)color) / 255.0f;
        for (class_2338 chest : chests) {
            class_2680 block = McUtils.mc().field_1687.method_8320(chest);
            if (block.method_27852(class_2246.field_10499) || block.method_27852(class_2246.field_10124)) continue;
            class_9974.method_62295((class_4587)poseStack, (class_4588)consumer, (class_238)new class_238(chest), (float)red, (float)green, (float)blue, (float)1.0f);
        }
        BUFFER_SOURCE.method_22993();
    }

    private static void renderPoints(class_4587 poseStack, Long2ObjectMap<List<ColoredPath>> points, long chunkLong) {
        List locations = (List)points.get(chunkLong);
        class_638 level = McUtils.mc().field_1687;
        if (level == null) {
            return;
        }
        switch ((LootrunFeature.PathType)((Object)Managers.Feature.getFeatureInstance(LootrunFeature.class).pathType.get())) {
            case TEXTURED: {
                LootrunRenderer.renderTexturedLootrunPoints(poseStack, locations, (class_1937)level, CustomRenderType.LOOTRUN_QUAD);
                break;
            }
            case LINE: {
                LootrunRenderer.renderNonTexturedLootrunPoints(poseStack, locations, (class_1937)level, CustomRenderType.LOOTRUN_LINE);
            }
        }
    }

    private static void renderNonTexturedLootrunPoints(class_4587 poseStack, List<ColoredPath> locations, class_1937 level, class_1921 renderType) {
        for (ColoredPath locationsInRoute : locations) {
            class_4588 consumer = BUFFER_SOURCE.getBuffer(renderType);
            Matrix4f lastMatrix = poseStack.method_23760().method_23761();
            boolean sourceBatchEnded = false;
            ColoredPath toRender = new ColoredPath(new ArrayList<ColoredPosition>());
            boolean pauseDraw = false;
            class_2338 lastBlockPos = null;
            for (ColoredPosition point : locationsInRoute.points()) {
                class_2338 blockPos = PosUtils.newBlockPos((class_2374)point.position());
                if (blockPos.equals(lastBlockPos)) {
                    if (!toRender.points().isEmpty()) {
                        toRender.points().add(point);
                    }
                } else {
                    BlockValidness blockValidness = BlockValidness.checkBlockValidness(level, point);
                    if (blockValidness == BlockValidness.VALID) {
                        pauseDraw = false;
                        if (sourceBatchEnded) {
                            consumer = BUFFER_SOURCE.getBuffer(renderType);
                            sourceBatchEnded = false;
                        }
                        LootrunRenderer.renderQueuedPoints(consumer, lastMatrix, toRender);
                        toRender.points().clear();
                    } else if (blockValidness == BlockValidness.HAS_BARRIER) {
                        pauseDraw = true;
                        toRender.points().clear();
                    } else {
                        pauseDraw = false;
                        toRender.points().add(point);
                        continue;
                    }
                }
                lastBlockPos = blockPos;
                if (!pauseDraw) {
                    LootrunRenderer.renderPoint(consumer, lastMatrix, point);
                    continue;
                }
                if (sourceBatchEnded) continue;
                BUFFER_SOURCE.method_22993();
                sourceBatchEnded = true;
            }
            if (sourceBatchEnded) continue;
            LootrunRenderer.renderQueuedPoints(consumer, lastMatrix, toRender);
            BUFFER_SOURCE.method_22993();
        }
    }

    private static void renderTexturedLootrunPoints(class_4587 poseStack, List<ColoredPath> locations, class_1937 level, class_1921 renderType) {
        class_4184 camera = McUtils.mc().field_1773.method_19418();
        poseStack.method_22903();
        poseStack.method_22904(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ColoredPath locationsInRoute : locations) {
            class_4588 consumer = BUFFER_SOURCE.getBuffer(renderType);
            ArrayList<Pair<ColoredPosition, ColoredPosition>> toRender = new ArrayList<Pair<ColoredPosition, ColoredPosition>>();
            boolean sourceBatchEnded = false;
            class_2338 lastBlockPos = null;
            boolean pauseDraw = false;
            for (int i = 0; i < locationsInRoute.points().size() - 1; i += 10) {
                ColoredPosition point = locationsInRoute.points().get(i);
                class_2338 blockPos = PosUtils.newBlockPos((class_2374)point.position());
                ColoredPosition end = locationsInRoute.points().get(Math.min(locationsInRoute.points().size() - 1, i + 1));
                Pair<ColoredPosition, ColoredPosition> pointPair = new Pair<ColoredPosition, ColoredPosition>(point, end);
                if (blockPos.equals(lastBlockPos)) {
                    if (!toRender.isEmpty()) {
                        toRender.add(pointPair);
                    }
                } else {
                    BlockValidness blockValidness = BlockValidness.checkBlockValidness(level, point);
                    if (blockValidness == BlockValidness.VALID) {
                        pauseDraw = false;
                        if (sourceBatchEnded) {
                            consumer = BUFFER_SOURCE.getBuffer(renderType);
                            sourceBatchEnded = false;
                        }
                        LootrunRenderer.renderTexturedQueuedPoints(toRender, poseStack, consumer);
                        toRender.clear();
                    } else if (blockValidness == BlockValidness.HAS_BARRIER) {
                        pauseDraw = true;
                        toRender.clear();
                    } else {
                        pauseDraw = false;
                        toRender.add(pointPair);
                        continue;
                    }
                }
                lastBlockPos = blockPos;
                if (!pauseDraw) {
                    LootrunRenderer.renderTexturedPoint(pointPair, poseStack, consumer);
                    continue;
                }
                if (sourceBatchEnded) continue;
                BUFFER_SOURCE.method_22993();
                sourceBatchEnded = true;
            }
            if (sourceBatchEnded) continue;
            LootrunRenderer.renderTexturedQueuedPoints(toRender, poseStack, consumer);
            BUFFER_SOURCE.method_22993();
        }
        poseStack.method_22909();
    }

    private static void renderQueuedPoints(class_4588 consumer, Matrix4f lastMatrix, ColoredPath toRender) {
        for (ColoredPosition position : toRender.points()) {
            LootrunRenderer.renderPoint(consumer, lastMatrix, position);
        }
    }

    private static void renderPoint(class_4588 consumer, Matrix4f lastMatrix, ColoredPosition coloredPosition) {
        class_243 position = coloredPosition.position();
        int pathColor = coloredPosition.color();
        consumer.method_22918(lastMatrix, (float)position.method_10216(), (float)position.method_10214(), (float)position.method_10215()).method_39415(pathColor).method_22914(0.0f, 0.0f, 1.0f);
    }

    private static void renderTexturedQueuedPoints(List<Pair<ColoredPosition, ColoredPosition>> pointPairList, class_4587 poseStack, class_4588 vertexConsumer) {
        for (Pair<ColoredPosition, ColoredPosition> pointPair : pointPairList) {
            LootrunRenderer.renderTexturedPoint(pointPair.a(), pointPair.b(), poseStack, vertexConsumer);
        }
    }

    private static void renderTexturedPoint(Pair<ColoredPosition, ColoredPosition> pointPair, class_4587 poseStack, class_4588 vertexConsumer) {
        LootrunRenderer.renderTexturedPoint(pointPair.a(), pointPair.b(), poseStack, vertexConsumer);
    }

    private static void renderTexturedPoint(ColoredPosition start, ColoredPosition end, class_4587 poseStack, class_4588 vertexConsumer) {
        Vector3f camPos = McUtils.mc().field_1773.method_19418().method_19326().method_46409();
        Vector3f startVec = start.position().method_46409();
        Vector3f endVec = end.position().method_46409();
        int color = start.color();
        Vector3f pos1 = new Vector3f(-0.5f, 0.24f, -0.5f);
        Vector3f pos2 = new Vector3f(0.5f, 0.24f, -0.5f);
        Vector3f pos3 = new Vector3f(0.5f, 0.24f, 0.5f);
        Vector3f pos4 = new Vector3f(-0.5f, 0.24f, 0.5f);
        Vector3f direction = new Vector3f(endVec.x, endVec.y, endVec.z).sub((Vector3fc)startVec).normalize();
        float xAngle = (float)((double)((float)Math.acos(direction.y / direction.length())) - 1.5707963267948966);
        float yAngle = (float)Math.atan2(direction.x, direction.z);
        Quaternionf yRot = new Quaternionf().rotateY(yAngle);
        Vector3f xRotAxis = new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)yRot);
        Quaternionf xRot = new Quaternionf().rotateAxis(xAngle, (Vector3fc)xRotAxis);
        pos1.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos2.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos3.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos4.rotate((Quaternionfc)yRot).rotate((Quaternionfc)xRot);
        pos1 = pos1.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos2 = pos2.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos3 = pos3.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        pos4 = pos4.add((Vector3fc)startVec).sub((Vector3fc)camPos);
        vertexConsumer.method_22918(poseStack.method_23760().method_23761(), pos1.x, pos1.y, pos1.z).method_22913(0.0f, 1.0f).method_39415(color);
        vertexConsumer.method_22918(poseStack.method_23760().method_23761(), pos2.x, pos2.y, pos2.z).method_22913(0.0f, 0.0f).method_39415(color);
        vertexConsumer.method_22918(poseStack.method_23760().method_23761(), pos3.x, pos3.y, pos3.z).method_22913(1.0f, 0.0f).method_39415(color);
        vertexConsumer.method_22918(poseStack.method_23760().method_23761(), pos4.x, pos4.y, pos4.z).method_22913(1.0f, 1.0f).method_39415(color);
    }
}

