/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.ping;

import com.wynntils.core.components.Service;
import com.wynntils.mc.event.PongReceivedEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_156;
import net.minecraft.class_2935;
import net.neoforged.bus.api.SubscribeEvent;

public class PingService
extends Service {
    private static final int MS_PER_PING = 1000;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private int lastPing = 0;

    public PingService() {
        super(List.of());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            this.executor.scheduleAtFixedRate(this::sendPingPacket, 0L, 1000L, TimeUnit.MILLISECONDS);
        } else {
            this.executor.shutdownNow();
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
    }

    @SubscribeEvent
    public void onPongReceived(PongReceivedEvent event) {
        this.lastPing = (int)(class_156.method_658() - event.getTime());
    }

    private void sendPingPacket() {
        McUtils.sendPacket(new class_2935(class_156.method_658()));
    }

    public int getPing() {
        return this.lastPing;
    }
}

