/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.persisted.config.NullableConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;

public final class EnumUtils {
    private static final Pattern NUM_AFTER_ALPHA_PATTERN = Pattern.compile("([a-z])(\\d)");

    public static List<? extends Enum<?>> getEnumConstants(Class<?> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            Class<?> enumClazz = clazz;
            return Arrays.stream((Enum[])enumClazz.getEnumConstants()).toList();
        }
        return List.of();
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        return null;
    }

    public static String toJsonFormat(Enum<?> enumValue) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumValue.name());
    }

    public static <E extends Enum<E>> E fromJsonFormat(Class<E> enumClazz, String jsonFormattedName) {
        String enumName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, NUM_AFTER_ALPHA_PATTERN.matcher(jsonFormattedName).replaceAll("$1_$2"));
        try {
            return Enum.valueOf(enumClazz, enumName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String toNiceString(Enum<?> enumValue) {
        if (EnumUtils.overridesToString(enumValue)) {
            return enumValue.toString();
        }
        return EnumUtils.toNiceString(enumValue.name());
    }

    public static String toNiceString(String variantName) {
        return WordUtils.capitalizeFully((String)variantName.replace("_", " "));
    }

    private static boolean overridesToString(Enum<?> enumValue) {
        try {
            enumValue.getDeclaringClass().getDeclaredMethod("toString", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Class<T> enumClazz;
        private final boolean nullAllowed;

        private EnumTypeAdapter(Class<T> enumClazz) {
            this.enumClazz = enumClazz;
            this.nullAllowed = NullableConfig.class.isAssignableFrom(enumClazz);
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (value != null) {
                out.value(EnumUtils.toJsonFormat(value));
            } else {
                if (!this.nullAllowed) {
                    WynntilsMod.warn("Writing null enum value to json for " + this.enumClazz.getSimpleName());
                }
                out.nullValue();
            }
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.STRING) {
                String jsonString = in.nextString();
                T value = EnumUtils.fromJsonFormat(this.enumClazz, jsonString);
                if (value == null) {
                    WynntilsMod.warn("Illegal enum value: " + jsonString + " for type " + this.enumClazz.getName());
                    return this.replacement();
                }
                return value;
            }
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                if (!this.nullAllowed) {
                    WynntilsMod.warn("Null enum value for type " + this.enumClazz.getName());
                    return this.replacement();
                }
                return null;
            }
            WynntilsMod.warn("Invalid json type " + String.valueOf(in.peek()) + " for enum " + this.enumClazz.getName());
            return this.replacement();
        }

        private T replacement() {
            Enum firstValue = ((Enum[])this.enumClazz.getEnumConstants())[0];
            WynntilsMod.warn("Will replace with first enum value: " + firstValue.name());
            return (T)firstValue;
        }
    }

    public static final class EnumTypeAdapterFactory<E extends Enum<E>>
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!type.getRawType().isEnum()) {
                return null;
            }
            Class enumClazz = type.getRawType();
            return new EnumTypeAdapter(enumClazz);
        }
    }
}

