/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private static final int NAMETAG_COLOR = 0x20FFFFFF;
    private static final float MAX_CIRCLE_STEPS = 16.0f;

    public static void drawLine(class_4587 poseStack, CustomColor color, float x1, float y1, float x2, float y2, float z, float width) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        float halfWidth = width / 2.0f;
        if (x1 == x2) {
            if (y2 < y1) {
                float tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            bufferBuilder.method_22918(matrix, x1 - halfWidth, y1, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 - halfWidth, y2, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x1 + halfWidth, y1, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 + halfWidth, y2, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else if (y1 == y2) {
            if (x2 < x1) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            bufferBuilder.method_22918(matrix, x1, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x1, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else if (x1 < x2 && y1 < y2 || x2 < x1 && y2 < y1) {
            if (x2 < x1) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            bufferBuilder.method_22918(matrix, x1 + halfWidth, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x1 - halfWidth, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 + halfWidth, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 - halfWidth, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        } else {
            if (x1 < x2) {
                float tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            bufferBuilder.method_22918(matrix, x1 + halfWidth, y1 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x1 - halfWidth, y1 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 + halfWidth, y2 + halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, x2 - halfWidth, y2 - halfWidth, z).method_1336(color.r(), color.g(), color.b(), color.a());
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableBlend();
    }

    public static void drawRectBorders(class_4587 poseStack, CustomColor color, float x1, float y1, float x2, float y2, float z, float lineWidth) {
        RenderUtils.drawLine(poseStack, color, x1, y1, x2, y1, z, lineWidth);
        RenderUtils.drawLine(poseStack, color, x2, y1, x2, y2, z, lineWidth);
        RenderUtils.drawLine(poseStack, color, x2, y2, x1, y2, z, lineWidth);
        RenderUtils.drawLine(poseStack, color, x1, y2, x1, y1, z, lineWidth);
    }

    public static void drawRotatingBorderSegment(class_4587 poseStack, CustomColor color, float x1, float y1, float x2, float y2, float z, float lineWidth, float segmentFraction) {
        float tmp;
        segmentFraction = MathUtils.clamp(segmentFraction, 0.0f, 1.0f);
        if (x2 < x1) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 < y1) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        float width = x2 - x1;
        float height = y2 - y1;
        float perimeter = 2.0f * (width + height);
        float progress = (float)(McUtils.player().field_6012 % 100) / 100.0f;
        float segmentLength = segmentFraction * perimeter;
        float offset = progress % 1.0f * perimeter;
        float[][] points = new float[][]{{x1, y1, x2, y1}, {x2, y1, x2, y2}, {x2, y2, x1, y2}, {x1, y2, x1, y1}};
        float remainingLength = segmentLength;
        float accumulatedLength = 0.0f;
        block0: for (int i = 0; i < points.length; ++i) {
            float[] edge = points[i];
            float edgeX2 = edge[2];
            float edgeX1 = edge[0];
            float edgeY2 = edge[3];
            float edgeY1 = edge[1];
            float edgeLength = (float)Math.hypot(edgeX2 - edgeX1, edgeY2 - edgeY1);
            if (offset < accumulatedLength + edgeLength) {
                float localOffset = offset - accumulatedLength;
                float segmentEdgeStart = localOffset / edgeLength;
                float startX = edgeX1 + (edgeX2 - edgeX1) * segmentEdgeStart;
                float startY = edgeY1 + (edgeY2 - edgeY1) * segmentEdgeStart;
                while (remainingLength > 0.0f) {
                    float segmentEdgeEnd = Math.min(1.0f, segmentEdgeStart + remainingLength / edgeLength);
                    float endX = edgeX1 + (edgeX2 - edgeX1) * segmentEdgeEnd;
                    float endY = edgeY1 + (edgeY2 - edgeY1) * segmentEdgeEnd;
                    RenderUtils.drawLine(poseStack, color, startX, startY, endX, endY, z, lineWidth);
                    remainingLength -= (segmentEdgeEnd - segmentEdgeStart) * edgeLength;
                    if (!(segmentEdgeEnd >= 1.0f)) break block0;
                    i = (i + 1) % points.length;
                    edge = points[i];
                    edgeX1 = edge[0];
                    edgeY1 = edge[1];
                    edgeX2 = edge[2];
                    edgeY2 = edge[3];
                    edgeLength = (float)Math.hypot(edgeX2 - edgeX1, edgeY2 - edgeY1);
                    segmentEdgeStart = 0.0f;
                    startX = edgeX1;
                    startY = edgeY1;
                }
                break;
            }
            accumulatedLength += edgeLength;
        }
    }

    public static void drawRect(class_4587 poseStack, CustomColor color, float x, float y, float z, float width, float height) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x + width, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x + width, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableBlend();
    }

    public static void drawHoverableTexturedRect(class_4587 poseStack, Texture texture, float x, float y, boolean hovered) {
        RenderUtils.drawTexturedRect(poseStack, texture.resource(), x, y, 0.0f, texture.width(), (float)texture.height() / 2.0f, 0, hovered ? texture.height() / 2 : 0, texture.width(), texture.height() / 2, texture.width(), texture.height());
    }

    public static void drawTexturedRect(class_4587 poseStack, Texture texture, float x, float y) {
        RenderUtils.drawTexturedRect(poseStack, texture.resource(), x, y, texture.width(), texture.height(), texture.width(), texture.height());
    }

    public static void drawTexturedRect(class_4587 poseStack, class_2960 tex, float x, float y, float width, float height, int textureWidth, int textureHeight) {
        RenderUtils.drawTexturedRect(poseStack, tex, x, y, 0.0f, width, height, 0, 0, (int)width, (int)height, textureWidth, textureHeight);
    }

    public static void drawTexturedRect(class_4587 poseStack, class_2960 tex, float x, float y, float z, float width, float height, int textureWidth, int textureHeight) {
        RenderUtils.drawTexturedRect(poseStack, tex, x, y, z, width, height, 0, 0, (int)width, (int)height, textureWidth, textureHeight);
    }

    public static void drawTexturedRect(class_4587 poseStack, class_2960 tex, float x, float y, float z, float width, float height, int uOffset, int vOffset, int u, int v, int textureWidth, int textureHeight) {
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderTexture((int)0, (class_2960)tex);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, x, y + height, z).method_22913((float)uOffset * uScale, (float)(vOffset + v) * vScale);
        bufferBuilder.method_22918(matrix, x + width, y + height, z).method_22913((float)(uOffset + u) * uScale, (float)(vOffset + v) * vScale);
        bufferBuilder.method_22918(matrix, x + width, y, z).method_22913((float)(uOffset + u) * uScale, (float)vOffset * vScale);
        bufferBuilder.method_22918(matrix, x, y, z).method_22913((float)uOffset * uScale, (float)vOffset * vScale);
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
    }

    public static void drawScalingTexturedRect(class_4587 poseStack, class_2960 tex, float x, float y, float z, float width, float height, int textureWidth, int textureHeight) {
        RenderUtils.drawTexturedRect(poseStack, tex, x, y, z, width, height, 0, 0, textureWidth, textureHeight, textureWidth, textureHeight);
    }

    public static void drawTexturedRectWithColor(class_4587 poseStack, class_2960 tex, CustomColor color, float x, float y, float z, float width, float height, int textureWidth, int textureHeight) {
        RenderUtils.drawTexturedRectWithColor(poseStack, tex, color, x, y, z, width, height, 0, 0, (int)width, (int)height, textureWidth, textureHeight);
    }

    public static void drawTexturedRectWithColor(class_4587 poseStack, class_2960 tex, CustomColor color, float x, float y, float z, float width, float height, int uOffset, int vOffset, int u, int v, int textureWidth, int textureHeight) {
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)tex);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix, x, y + height, z).method_22913((float)uOffset * uScale, (float)(vOffset + v) * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x + width, y + height, z).method_22913((float)(uOffset + u) * uScale, (float)(vOffset + v) * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x + width, y, z).method_22913((float)(uOffset + u) * uScale, (float)vOffset * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        bufferBuilder.method_22918(matrix, x, y, z).method_22913((float)uOffset * uScale, (float)vOffset * vScale).method_1336(color.r(), color.g(), color.b(), color.a());
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableBlend();
    }

    public static void drawArc(class_4587 poseStack, CustomColor color, float x, float y, float z, float fill, int innerRadius, int outerRadius) {
        RenderUtils.drawArc(poseStack, color, x, y, z, fill, innerRadius, outerRadius, 0.0f);
    }

    public static void drawArc(class_4587 poseStack, CustomColor color, float x, float y, float z, float fill, int innerRadius, int outerRadius, float angleOffset) {
        int segments = (int)Math.min(fill * 16.0f, 15.0f);
        float midX = x + (float)outerRadius;
        float midY = y + (float)outerRadius;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / 15.0f + angleOffset;
            float sinAngle = class_3532.method_15374((float)angle);
            float cosAngle = class_3532.method_15362((float)angle);
            bufferBuilder.method_22918(matrix, midX + sinAngle * (float)outerRadius, midY - cosAngle * (float)outerRadius, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, midX + sinAngle * (float)innerRadius, midY - cosAngle * (float)innerRadius, z).method_1336(color.r(), color.g(), color.b(), color.a());
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRectWithBorder(class_4587 poseStack, CustomColor borderColor, CustomColor fillColor, float x, float y, float z, float width, float height, float lineWidth, int innerRadius, int outerRadius) {
        float x2 = x + width;
        float y2 = y + height;
        int fillOffset = (int)lineWidth;
        RenderUtils.drawRect(poseStack, fillColor, x + (float)fillOffset, y + (float)fillOffset, z, width - (float)(fillOffset * 2), height - (float)(fillOffset * 2));
        RenderUtils.drawLine(poseStack, fillColor, x + (float)fillOffset, y + (float)fillOffset, x2 - (float)fillOffset, y + (float)fillOffset, z, lineWidth);
        RenderUtils.drawLine(poseStack, fillColor, x2 - (float)fillOffset, y + (float)fillOffset, x2 - (float)fillOffset, y2 - (float)fillOffset, z, lineWidth);
        RenderUtils.drawLine(poseStack, fillColor, x + (float)fillOffset, y2 - (float)fillOffset, x2 - (float)fillOffset, y2 - (float)fillOffset, z, lineWidth);
        RenderUtils.drawLine(poseStack, fillColor, x + (float)fillOffset, y + (float)fillOffset, x + (float)fillOffset, y2 - (float)fillOffset, z, lineWidth);
        float offset = outerRadius - 1;
        RenderUtils.drawLine(poseStack, borderColor, x + offset, y, x2 - offset, y, z, lineWidth);
        RenderUtils.drawLine(poseStack, borderColor, x2, y + offset, x2, y2 - offset, z, lineWidth);
        RenderUtils.drawLine(poseStack, borderColor, x + offset, y2, x2 - offset, y2, z, lineWidth);
        RenderUtils.drawLine(poseStack, borderColor, x, y + offset, x, y2 - offset, z, lineWidth);
        poseStack.method_22903();
        poseStack.method_46416(-1.0f, -1.0f, 0.0f);
        RenderUtils.drawRoundedCorner(poseStack, borderColor, x, y, z, innerRadius, outerRadius, 4.712389f);
        RenderUtils.drawRoundedCorner(poseStack, borderColor, x, y2 - offset * 2.0f, z, innerRadius, outerRadius, (float)Math.PI);
        RenderUtils.drawRoundedCorner(poseStack, borderColor, x2 - offset * 2.0f, y2 - offset * 2.0f, z, innerRadius, outerRadius, 1.5707964f);
        RenderUtils.drawRoundedCorner(poseStack, borderColor, x2 - offset * 2.0f, y, z, innerRadius, outerRadius, 0.0f);
        poseStack.method_22909();
    }

    private static void drawRoundedCorner(class_4587 poseStack, CustomColor color, float x, float y, float z, int innerRadius, int outerRadius, float angleOffset) {
        RenderUtils.drawArc(poseStack, color, x, y, z, 0.25f, innerRadius, outerRadius, angleOffset);
    }

    public static void drawColoredProgressBar(class_4587 poseStack, Texture texture, CustomColor customColor, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
        RenderUtils.drawProgressBarBackground(poseStack, texture, x1, y1, x2, y2, textureX1, textureY1, textureX2, half);
        RenderUtils.drawProgressBarForegroundWithColor(poseStack, texture, customColor, x1, y1, x2, y2, textureX1, half, textureX2, textureY2 + (textureY2 - textureY1) % 2, progress);
    }

    public static void drawProgressBar(class_4587 poseStack, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        int half = (textureY1 + textureY2) / 2 + (textureY2 - textureY1) % 2;
        RenderUtils.drawProgressBarBackground(poseStack, texture, x1, y1, x2, y2, textureX1, textureY1, textureX2, half);
        RenderUtils.drawProgressBarForeground(poseStack, texture, x1, y1, x2, y2, textureX1, half, textureX2, textureY2 + (textureY2 - textureY1) % 2, progress);
    }

    private static void drawProgressBarForeground(class_4587 poseStack, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        if (progress == 0.0f) {
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture.resource());
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        if (progress < 1.0f && progress > -1.0f) {
            if (progress < 0.0f) {
                xMin += (1.0f + progress) * (xMax - xMin);
                txMin += (1.0f + progress) * (txMax - txMin);
            } else {
                xMax -= (1.0f - progress) * (xMax - xMin);
                txMax -= (1.0f - progress) * (txMax - txMin);
            }
        }
        bufferBuilder.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin);
        bufferBuilder.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax);
        bufferBuilder.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax);
        bufferBuilder.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin);
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
    }

    private static void drawProgressBarForegroundWithColor(class_4587 poseStack, Texture texture, CustomColor customColor, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2, float progress) {
        if (progress == 0.0f) {
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture.resource());
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        if (progress < 1.0f && progress > -1.0f) {
            if (progress < 0.0f) {
                xMin += (1.0f + progress) * (xMax - xMin);
                txMin += (1.0f + progress) * (txMax - txMin);
            } else {
                xMax -= (1.0f - progress) * (xMax - xMin);
                txMax -= (1.0f - progress) * (txMax - txMin);
            }
        }
        bufferBuilder.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin).method_39415(customColor.asInt());
        bufferBuilder.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax).method_39415(customColor.asInt());
        bufferBuilder.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax).method_39415(customColor.asInt());
        bufferBuilder.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin).method_39415(customColor.asInt());
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
    }

    private static void drawProgressBarBackground(class_4587 poseStack, Texture texture, float x1, float y1, float x2, float y2, int textureX1, int textureY1, int textureX2, int textureY2) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture.resource());
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float xMin = Math.min(x1, x2);
        float xMax = Math.max(x1, x2);
        float yMin = Math.min(y1, y2);
        float yMax = Math.max(y1, y2);
        float txMin = (float)Math.min(textureX1, textureX2) / (float)texture.width();
        float txMax = (float)Math.max(textureX1, textureX2) / (float)texture.width();
        float tyMin = (float)Math.min(textureY1, textureY2) / (float)texture.height();
        float tyMax = (float)Math.max(textureY1, textureY2) / (float)texture.height();
        bufferBuilder.method_22918(matrix, xMin, yMin, 0.0f).method_22913(txMin, tyMin);
        bufferBuilder.method_22918(matrix, xMin, yMax, 0.0f).method_22913(txMin, tyMax);
        bufferBuilder.method_22918(matrix, xMax, yMax, 0.0f).method_22913(txMax, tyMax);
        bufferBuilder.method_22918(matrix, xMax, yMin, 0.0f).method_22913(txMax, tyMin);
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
    }

    public static void fillGradient(class_4587 poseStack, float x1, float y1, float x2, float y2, int blitOffset, CustomColor colorA, CustomColor colorB) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x2, y1, (float)blitOffset).method_1336(colorA.r(), colorA.g(), colorA.b(), colorA.a());
        bufferBuilder.method_22918(matrix, x1, y1, (float)blitOffset).method_1336(colorA.r(), colorA.g(), colorA.b(), colorA.a());
        bufferBuilder.method_22918(matrix, x1, y2, (float)blitOffset).method_1336(colorB.r(), colorB.g(), colorB.b(), colorB.a());
        bufferBuilder.method_22918(matrix, x2, y2, (float)blitOffset).method_1336(colorB.r(), colorB.g(), colorB.b(), colorB.a());
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void fillSidewaysGradient(class_4587 poseStack, float x1, float y1, float x2, float y2, int blitOffset, CustomColor colorA, CustomColor colorB) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x1, y1, (float)blitOffset).method_1336(colorA.r(), colorA.g(), colorA.b(), colorA.a());
        bufferBuilder.method_22918(matrix, x1, y2, (float)blitOffset).method_1336(colorA.r(), colorA.g(), colorA.b(), colorA.a());
        bufferBuilder.method_22918(matrix, x2, y2, (float)blitOffset).method_1336(colorB.r(), colorB.g(), colorB.b(), colorB.a());
        bufferBuilder.method_22918(matrix, x2, y1, (float)blitOffset).method_1336(colorB.r(), colorB.g(), colorB.b(), colorB.a());
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void enableScissor(class_332 guiGraphics, int x, int y, int width, int height) {
        guiGraphics.method_44379(x, y, x + width, y + height);
    }

    public static void disableScissor(class_332 guiGraphics) {
        if (guiGraphics.field_44659.field_43099.isEmpty()) {
            return;
        }
        guiGraphics.method_44380();
    }

    public static void rotatePose(class_4587 poseStack, float centerX, float centerZ, float angle) {
        poseStack.method_46416(centerX, centerZ, 0.0f);
        poseStack.method_22907(new Quaternionf(0.0f, 0.0f, (float)StrictMath.sin(Math.toRadians(angle) / 2.0), (float)StrictMath.cos(-Math.toRadians(angle) / 2.0)));
        poseStack.method_46416(-centerX, -centerZ, 0.0f);
    }

    public static void renderItem(class_332 guiGraphics, class_1799 itemStack, int x, int y) {
        guiGraphics.method_51427(itemStack, x, y);
    }

    public static void renderVignetteOverlay(class_4587 poseStack, CustomColor color, float alpha) {
        float[] colorArray = color.asFloatArray();
        RenderSystem.setShaderColor((float)colorArray[0], (float)colorArray[1], (float)colorArray[2], (float)alpha);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        class_1041 window = McUtils.window();
        RenderUtils.drawTexturedRect(poseStack, Texture.VIGNETTE.resource(), 0.0f, 0.0f, 0.0f, window.method_4486(), window.method_4502(), 0, 0, Texture.VIGNETTE.width(), Texture.VIGNETTE.height(), Texture.VIGNETTE.width(), Texture.VIGNETTE.height());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public static void renderCustomNametag(class_4587 matrixStack, class_4597 buffer, int packedLight, int backgroundColor, class_898 dispatcher, class_1297 entity, class_2561 nametag, class_327 font, float nametagScale, float customOffset) {
        double d = dispatcher.method_23168(entity);
        if (d <= 4096.0) {
            float yOffset = entity.method_17682() + 0.25f + customOffset;
            float xOffset = -((float)font.method_27525((class_5348)nametag) / 2.0f);
            boolean sneaking = entity.method_21751();
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, yOffset, 0.0f);
            matrixStack.method_22907(dispatcher.method_24197());
            matrixStack.method_22905(0.025f * nametagScale, -0.025f * nametagScale, 0.025f * nametagScale);
            Matrix4f matrix4f = matrixStack.method_23760().method_23761();
            font.method_27522(nametag, xOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, sneaking ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, backgroundColor, packedLight);
            if (!sneaking) {
                font.method_27522(nametag, xOffset, 0.0f, -1, false, matrix4f, buffer, class_327.class_6415.field_33993, 0, packedLight);
            }
            matrixStack.method_22909();
        }
    }

    public static void renderProfessionBadge(class_4587 poseStack, class_898 dispatcher, class_1297 entity, class_2960 tex, float width, float height, int uOffset, int vOffset, int u, int v, int textureWidth, int textureHeight, float customOffset, float horizontalShift, float verticalShift) {
        double d = dispatcher.method_23168(entity);
        if (d <= 4096.0) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, entity.method_17682() + 0.25f + customOffset, 0.0f);
            poseStack.method_22907(dispatcher.method_24197());
            poseStack.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f matrix = poseStack.method_23760().method_23761();
            float halfWidth = width / 2.0f;
            float halfHeight = height / 2.0f;
            float uScale = 1.0f / (float)textureWidth;
            float vScale = 1.0f / (float)textureHeight;
            RenderSystem.enableDepthTest();
            RenderSystem.setShader((class_10156)class_10142.field_53879);
            RenderSystem.setShaderTexture((int)0, (class_2960)tex);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix, -halfWidth + horizontalShift, -halfHeight - verticalShift, 0.0f).method_22913((float)uOffset * uScale, (float)vOffset * vScale);
            bufferBuilder.method_22918(matrix, -halfWidth + horizontalShift, halfHeight - verticalShift, 0.0f).method_22913((float)uOffset * uScale, (float)(v + vOffset) * vScale);
            bufferBuilder.method_22918(matrix, halfWidth + horizontalShift, halfHeight - verticalShift, 0.0f).method_22913((float)(u + uOffset) * uScale, (float)(v + vOffset) * vScale);
            bufferBuilder.method_22918(matrix, halfWidth + horizontalShift, -halfHeight - verticalShift, 0.0f).method_22913((float)(u + uOffset) * uScale, (float)vOffset * vScale);
            class_286.method_43433((class_9801)bufferBuilder.method_60794());
            RenderSystem.disableDepthTest();
            poseStack.method_22909();
        }
    }

    public static void drawMulticoloredRect(class_4587 poseStack, List<CustomColor> colors, float x, float y, float z, float width, float height) {
        if (colors.size() == 1) {
            RenderUtils.drawRect(poseStack, colors.getFirst(), x, y, z, width, height);
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        float splitX = width / (float)(colors.size() - 1);
        for (int i = 0; i < colors.size(); ++i) {
            CustomColor color = colors.get(i);
            float leftX = class_3532.method_15363((float)(x + splitX * (float)(i - 1)), (float)x, (float)(x + width));
            float centerX = class_3532.method_15363((float)(x + splitX * (float)i), (float)x, (float)(x + width));
            float rightX = class_3532.method_15363((float)(x + splitX * (float)(i + 1)), (float)x, (float)(x + width));
            bufferBuilder.method_22918(matrix, leftX, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, centerX, y + height, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, rightX, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
            bufferBuilder.method_22918(matrix, centerX, y, z).method_1336(color.r(), color.g(), color.b(), color.a());
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void createMask(class_4587 poseStack, Texture texture, int x1, int y1, int x2, int y2) {
        RenderUtils.createMask(poseStack, texture, x1, y1, x2, y2, 0, 0, texture.width(), texture.height());
    }

    public static void createMask(class_4587 poseStack, Texture texture, float x1, float y1, float x2, float y2, int tx1, int ty1, int tx2, int ty2) {
        GL11.glEnable((int)2960);
        RenderSystem.stencilMask((int)255);
        RenderSystem.clear((int)1024);
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        int width = texture.width();
        int height = texture.height();
        RenderUtils.drawTexturedRect(poseStack, texture.resource(), x1, y1, 0.0f, x2 - x1, y2 - y1, tx1, ty1, tx2 - tx1, ty2 - ty1, width, height);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }

    public static void createRectMask(class_4587 poseStack, float x, float y, float width, float height) {
        GL11.glEnable((int)2960);
        RenderSystem.stencilMask((int)255);
        RenderSystem.clear((int)1024);
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderUtils.drawRect(poseStack, CommonColors.WHITE, x, y, 0.0f, width, height);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
    }

    public static void clearMask() {
        RenderSystem.clear((int)1024);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
    }

    public static void renderDebugGrid(class_4587 poseStack, float gridDivisions, float dividedWidth, float dividedHeight) {
        int i = 1;
        while ((float)i <= gridDivisions - 1.0f) {
            double x = dividedWidth * (float)i;
            double y = dividedHeight * (float)i;
            RenderUtils.drawRect(poseStack, CommonColors.GRAY, (float)x, 0.0f, 0.0f, 1.0f, dividedHeight * gridDivisions);
            RenderUtils.drawRect(poseStack, CommonColors.GRAY, 0.0f, (float)y, 0.0f, dividedWidth * gridDivisions, 1.0f);
            if (i % 2 != 0) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(i)), (float)x, dividedHeight * (gridDivisions / 2.0f), CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(i)), dividedWidth * (gridDivisions / 2.0f), (float)y, CommonColors.CYAN, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            }
            ++i;
        }
    }
}

