/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.map.pois.LabelPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.ServicePoi;
import com.wynntils.services.map.type.ServiceKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.Vec3;

public class LocateCommand
extends Command {
    public static final SuggestionProvider<CommandSourceStack> SERVICE_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(ServiceKind.values()).map(ServiceKind::getName), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> PLACES_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Services.Poi.getLabelPois().map(Poi::getName), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "locate";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(Commands.literal((String)"service").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(SERVICE_SUGGESTION_PROVIDER).executes(this::locateService)))).then(Commands.literal((String)"place").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(PLACES_SUGGESTION_PROVIDER).executes(this::locatePlace)))).then(Commands.literal((String)"npc").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(Commands.literal((String)"other").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).executes(this::syntaxError);
    }

    public static ServiceKind getServiceKind(CommandContext<CommandSourceStack> context, String searchedName) {
        List<ServiceKind> matchedKinds = Arrays.stream(ServiceKind.values()).filter(kind -> StringUtils.partialMatch(kind.getName(), searchedName)).toList();
        if (matchedKinds.isEmpty()) {
            MutableComponent response = Component.literal((String)("Found no services matching '" + searchedName + "'")).withStyle(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
            return null;
        }
        if (matchedKinds.size() > 1) {
            Optional<ServiceKind> exactMatch = matchedKinds.stream().filter(k -> k.getName().equals(searchedName)).findFirst();
            if (exactMatch.isPresent()) {
                return exactMatch.get();
            }
            MutableComponent response = Component.literal((String)("Found multiple services matching '" + searchedName + "'. Please specify with more detail. Matching: ")).withStyle(ChatFormatting.RED);
            response.append((Component)Component.literal((String)String.join((CharSequence)", ", matchedKinds.stream().map(ServiceKind::getName).toList())));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
            return null;
        }
        return matchedKinds.getFirst();
    }

    private int locateService(CommandContext<CommandSourceStack> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ServiceKind selectedKind = LocateCommand.getServiceKind(context, searchedName);
        if (selectedKind == null) {
            return 0;
        }
        ArrayList<ServicePoi> services = new ArrayList<ServicePoi>(Services.Poi.getServicePois().filter(poi -> poi.getKind() == selectedKind).toList());
        Vec3 currentLocation = McUtils.player().position();
        services.sort(Comparator.comparingDouble(poi -> currentLocation.distanceToSqr((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.y).intValue(), (double)poi.getLocation().getZ())));
        if (services.size() > 4) {
            services.subList(4, services.size()).clear();
        }
        MutableComponent response = Component.literal((String)("Found " + selectedKind.getName() + " services:")).withStyle(ChatFormatting.AQUA);
        for (Poi poi2 : services) {
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(poi2.getName() + " ")).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/compass at " + service.getLocation().asChatCoordinates())))).append((Component)Component.literal((String)poi2.getLocation().toString()).withStyle(ChatFormatting.WHITE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/compass at " + service.getLocation().asChatCoordinates()))));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int locatePlace(CommandContext<CommandSourceStack> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ArrayList<LabelPoi> places = new ArrayList<LabelPoi>(Services.Poi.getLabelPois().filter(poi -> StringUtils.partialMatch(poi.getName(), searchedName)).toList());
        if (places.isEmpty()) {
            MutableComponent response = Component.literal((String)("Found no places matching '" + searchedName + "'")).withStyle(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)response);
            return 0;
        }
        Vec3 currentLocation = McUtils.player().position();
        places.sort(Comparator.comparingDouble(poi -> currentLocation.distanceToSqr((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.y).intValue(), (double)poi.getLocation().getZ())));
        MutableComponent response = Component.literal((String)("Found places matching '" + searchedName + "':")).withStyle(ChatFormatting.AQUA);
        for (Poi poi2 : places) {
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(poi2.getName() + " ")).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/compass place " + place.getName())))).append((Component)Component.literal((String)poi2.getLocation().toString()).withStyle(ChatFormatting.WHITE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/compass place " + place.getName()))));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int notImplemented(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Not implemented yet").withStyle(ChatFormatting.RED));
        return 0;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }
}

