/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.arguments.parser;

import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.expressions.ConstantExpression;
import com.wynntils.core.consumers.functions.expressions.Expression;
import com.wynntils.core.consumers.functions.expressions.parser.ExpressionParser;
import com.wynntils.utils.type.ErrorOr;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ArgumentParser {
    public static ErrorOr<List<Expression>> parseArguments(FunctionArguments.Builder argumentsBuilder, String rawArgs) {
        if (rawArgs == null || rawArgs.isEmpty()) {
            if (argumentsBuilder.getArgumentCount() == 0) {
                return ErrorOr.of(List.of());
            }
            if (argumentsBuilder instanceof FunctionArguments.OptionalArgumentBuilder) {
                FunctionArguments.OptionalArgumentBuilder optionalArgumentBuilder = (FunctionArguments.OptionalArgumentBuilder)argumentsBuilder;
                return ErrorOr.of(optionalArgumentBuilder.getDefaults().stream().map(ConstantExpression::fromObject).toList());
            }
            return ErrorOr.error("Missing required arguments: (%s)".formatted(argumentsBuilder.getArgumentNamesString()));
        }
        List<ErrorOr> parts = ArgumentParser.splitArguments(rawArgs).stream().map(String::trim).map(ExpressionParser::tryParse).toList();
        Optional<ErrorOr> optionalError = parts.stream().filter(ErrorOr::hasError).findFirst();
        if (optionalError.isPresent()) {
            return ErrorOr.error(optionalError.get().getError());
        }
        return ErrorOr.of(parts.stream().map(ErrorOr::getValue).toList());
    }

    private static List<String> splitArguments(String rawArgs) {
        ArrayList<String> arguments = new ArrayList<String>();
        int parenthesesDepth = 0;
        int processedIndex = 0;
        boolean inString = false;
        int previous = 32;
        for (int i = 0; i < rawArgs.length(); ++i) {
            char current = rawArgs.charAt(i);
            if (current == '\"' && previous != 92) {
                inString = !inString;
            } else {
                if (inString) continue;
                if (current == '(') {
                    ++parenthesesDepth;
                } else if (current == ')') {
                    --parenthesesDepth;
                } else if (current == ';' && parenthesesDepth == 0) {
                    arguments.add(rawArgs.substring(processedIndex, i));
                    processedIndex = i + 1;
                }
            }
            previous = current;
        }
        arguments.add(rawArgs.substring(processedIndex));
        return arguments;
    }
}

