/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.notifications;

import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.utils.render.TextRenderTask;

public class TimedMessageContainer {
    private final MessageContainer messageContainer;
    private long endTime;

    public TimedMessageContainer(MessageContainer messageContainer, long messageDisplayLength) {
        this.messageContainer = messageContainer;
        this.endTime = messageDisplayLength + System.currentTimeMillis();
    }

    public void resetRemainingTime(long messageDisplayLength) {
        this.endTime = messageDisplayLength + System.currentTimeMillis();
    }

    public MessageContainer getMessageContainer() {
        return this.messageContainer;
    }

    public long getRemainingTime() {
        return this.endTime - System.currentTimeMillis();
    }

    public TextRenderTask getRenderTask() {
        return this.messageContainer.getRenderTask();
    }

    public long getEndTime() {
        return this.endTime;
    }
}

