/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.CorruptedCacheItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public class ValuableFoundFeature
extends Feature {
    private static final ResourceLocation MYTHIC_FOUND_CLASSIC_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"misc.mythic-found-classic");
    private static final ResourceLocation MYTHIC_FOUND_MODERN_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"misc.mythic-found-modern");
    private static final ResourceLocation CACHE_FOUND_ID = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)"misc.cache-found");
    @Persisted
    private final Config<ValuableFoundSound> chestSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> lootrunSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> aspectFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> tomeFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.NONE);
    @Persisted
    private final Config<ValuableFoundSound> cacheFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.CACHE);
    @Persisted
    private final Config<ValuableFoundSound> emeraldPouchSound = new Config<ValuableFoundSound>(ValuableFoundSound.NONE);
    @Persisted
    private final Config<Boolean> showDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showAspectDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showTomeDryStreakMessage = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> showCacheDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showEmeraldPouchDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<EmeraldPouchTier> emeraldPouchTier = new Config<EmeraldPouchTier>(EmeraldPouchTier.EIGHT);
    @Persisted
    private final Config<Float> soundVolume = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Float> soundPitch = new Config<Float>(Float.valueOf(1.0f));

    @SubscribeEvent
    public void onValuableFound(ValuableFoundEvent event) {
        Optional<CorruptedCacheItem> cacheItem;
        ItemStack itemStack = event.getItem();
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.LOOT_CHEST) {
            Optional<GearBoxItem> gearBoxItem;
            if ((((Boolean)this.showDryStreakMessage.get()).booleanValue() || this.chestSound.get() != ValuableFoundSound.NONE) && (gearBoxItem = Models.Item.asWynnItem(itemStack, GearBoxItem.class)).isPresent()) {
                if (gearBoxItem.get().getGearType() != GearType.MASTERY_TOME) {
                    if (this.chestSound.get() != ValuableFoundSound.NONE) {
                        McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.chestSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                    }
                    if (!((Boolean)this.showDryStreakMessage.get()).booleanValue()) {
                        return;
                    }
                    ValuableFoundFeature.sendNormalDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()));
                }
                return;
            }
            if (this.emeraldPouchTier.get() != EmeraldPouchTier.NONE && (((Boolean)this.showEmeraldPouchDryStreakMessage.get()).booleanValue() || this.emeraldPouchSound.get() != ValuableFoundSound.NONE)) {
                Optional<EmeraldPouchItem> emeraldPouchItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
                if (emeraldPouchItem.isPresent() && emeraldPouchItem.get().getTier() >= ((EmeraldPouchTier)((Object)this.emeraldPouchTier.get())).getTier()) {
                    if (this.emeraldPouchSound.get() != ValuableFoundSound.NONE) {
                        McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.emeraldPouchSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                    }
                    if (!((Boolean)this.showEmeraldPouchDryStreakMessage.get()).booleanValue()) {
                        return;
                    }
                    ValuableFoundFeature.sendEmeraldPouchDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()), ((EmeraldPouchTier)((Object)this.emeraldPouchTier.get())).getTier());
                }
                return;
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.LOOTRUN_REWARD_CHEST && (((Boolean)this.showDryStreakMessage.get()).booleanValue() || this.lootrunSound.get() != ValuableFoundSound.NONE)) {
            Optional<SimulatorItem> simulatorItem;
            Optional<InsulatorItem> insulatorItem;
            boolean validLootrunMythic = false;
            Optional<GearItem> gearItem = Models.Item.asWynnItem(itemStack, GearItem.class);
            if (gearItem.isPresent()) {
                validLootrunMythic = true;
            }
            if ((insulatorItem = Models.Item.asWynnItem(itemStack, InsulatorItem.class)).isPresent()) {
                validLootrunMythic = true;
            }
            if ((simulatorItem = Models.Item.asWynnItem(itemStack, SimulatorItem.class)).isPresent()) {
                validLootrunMythic = true;
            }
            if (validLootrunMythic) {
                if (this.lootrunSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.lootrunSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (!((Boolean)this.showDryStreakMessage.get()).booleanValue()) {
                    return;
                }
                this.sendLootrunDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()));
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.RAID_REWARD_CHEST) {
            Optional<TomeItem> tomeItem;
            Optional<AspectItem> aspectItem;
            if ((((Boolean)this.showAspectDryStreakMessage.get()).booleanValue() || this.aspectFoundSound.get() != ValuableFoundSound.NONE) && (aspectItem = Models.Item.asWynnItem(itemStack, AspectItem.class)).isPresent()) {
                if (this.aspectFoundSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.aspectFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (((Boolean)this.showAspectDryStreakMessage.get()).booleanValue()) {
                    ValuableFoundFeature.sendAspectDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()));
                }
                return;
            }
            if ((((Boolean)this.showTomeDryStreakMessage.get()).booleanValue() || this.tomeFoundSound.get() != ValuableFoundSound.NONE) && (tomeItem = Models.Item.asWynnItem(itemStack, TomeItem.class)).isPresent()) {
                if (this.tomeFoundSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.tomeFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (((Boolean)this.showTomeDryStreakMessage.get()).booleanValue()) {
                    ValuableFoundFeature.sendTomeDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()));
                }
                return;
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.WORLD_EVENT && (((Boolean)this.showCacheDryStreakMessage.get()).booleanValue() || this.cacheFoundSound.get() != ValuableFoundSound.NONE) && (cacheItem = Models.Item.asWynnItem(itemStack, CorruptedCacheItem.class)).isPresent()) {
            if (this.cacheFoundSound.get() != ValuableFoundSound.NONE) {
                McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.cacheFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
            }
            if (((Boolean)this.showCacheDryStreakMessage.get()).booleanValue()) {
                ValuableFoundFeature.sendCacheDryStreakMessage(StyledText.fromComponent(event.getItem().getHoverName()));
            }
            return;
        }
    }

    private void sendLootrunDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((Component)Component.literal((String)"Dry streak broken! Found an ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)itemName.getComponent()).append((Component)Component.literal((String)" after ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)(String.valueOf(Models.Lootrun.dryPulls.get()) + " pulls")).withStyle(ChatFormatting.GOLD))).append((Component)Component.literal((String)" without a mythic.").withStyle(ChatFormatting.LIGHT_PURPLE)));
    }

    private static void sendNormalDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((Component)Component.literal((String)"Dry streak broken! Found an ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)itemName.getComponent()).append((Component)Component.literal((String)" in chest ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)("#" + Models.LootChest.getOpenedChestCount())).withStyle(ChatFormatting.GOLD))).append((Component)Component.literal((String)" after ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)String.valueOf(Models.LootChest.getDryCount())).withStyle(ChatFormatting.DARK_PURPLE))).append((Component)Component.literal((String)" dry chests and ")).append((Component)Component.literal((String)String.valueOf(Models.LootChest.getDryBoxes())).withStyle(ChatFormatting.DARK_PURPLE)).append((Component)Component.literal((String)" dry boxes.")));
    }

    private static void sendCacheDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((Component)Component.literal((String)"Dry streak broken! Found a ").withColor(CustomColor.fromHexString("#800080").asInt()).append((Component)itemName.getComponent()).append((Component)Component.literal((String)" after ").withColor(CustomColor.fromHexString("#800080").asInt()).append((Component)Component.literal((String)String.valueOf(Models.WorldEvent.dryAnnihilations.get())).withColor(CustomColor.fromHexString("#FFD700").asInt()))).append((Component)Component.literal((String)" dry Annihilations.").withColor(CustomColor.fromHexString("#800080").asInt())));
    }

    private static void sendEmeraldPouchDryStreakMessage(StyledText itemName, int tier) {
        McUtils.sendMessageToClient((Component)Component.literal((String)"Dry streak broken! Found an ").withColor(CustomColor.fromHexString("#7CFC00").asInt()).append((Component)itemName.getComponent()).append((Component)Component.literal((String)" in chest ").withColor(CustomColor.fromHexString("#7CFC00").asInt()).append((Component)Component.literal((String)("#" + Models.LootChest.getOpenedChestCount())).withStyle(ChatFormatting.DARK_AQUA))).append((Component)Component.literal((String)" after ").withColor(CustomColor.fromHexString("#7CFC00").asInt()).append((Component)Component.literal((String)String.valueOf(Models.LootChest.getDryPouchCount(tier))).withColor(CustomColor.fromHexString("#228B22").asInt()))).append((Component)Component.literal((String)" dry chests.")));
    }

    private static void sendAspectDryStreakMessage(StyledText itemName) {
        ValuableFoundFeature.sendRaidDryStreakMessage(itemName, Models.Raid.getRaidsWithoutMythicAspect(), Models.Raid.getAspectPullsWithoutMythicAspect(), "aspect");
    }

    private static void sendTomeDryStreakMessage(StyledText itemName) {
        ValuableFoundFeature.sendRaidDryStreakMessage(itemName, Models.Raid.getRaidsWithoutMythicTome(), Models.Raid.getRewardPullsWithoutMythicTome(), "reward");
    }

    private static void sendRaidDryStreakMessage(StyledText itemName, int numRaids, int numPulls, String pullType) {
        McUtils.sendMessageToClient((Component)Component.literal((String)"Dry streak broken! Found ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)itemName.getComponent()).append((Component)Component.literal((String)" after ").withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)Component.literal((String)(numRaids + " raids")).withStyle(ChatFormatting.GOLD))).append((Component)Component.literal((String)" and ").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)Component.literal((String)(numPulls + " " + pullType + " pulls")).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" without a mythic.")).withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    private static enum ValuableFoundSound {
        MODERN(SoundEvent.createVariableRangeEvent((ResourceLocation)MYTHIC_FOUND_MODERN_ID)),
        CLASSIC(SoundEvent.createVariableRangeEvent((ResourceLocation)MYTHIC_FOUND_CLASSIC_ID)),
        CACHE(SoundEvent.createVariableRangeEvent((ResourceLocation)CACHE_FOUND_ID)),
        NONE(null);

        private final SoundEvent soundEvent;

        private ValuableFoundSound(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }
    }

    private static enum EmeraldPouchTier {
        NONE(-1),
        SEVEN(7),
        EIGHT(8),
        NINE(9),
        TEN(10);

        private final int tier;

        private EmeraldPouchTier(int tier) {
            this.tier = tier;
        }

        public int getTier() {
            return this.tier;
        }
    }
}

