/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.embellishments;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.DataComponentGetEvent;
import com.wynntils.models.items.properties.ShinyItemProperty;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.EMBELLISHMENTS)
public class RemoveShinyGlintFeature
extends Feature {
    private static final int SHINY_GLINT_COLOR = 0x1FFF00;
    @Persisted
    private final Config<Boolean> replaceGlint = new Config<Boolean>(true);

    @SubscribeEvent
    public void onGetPotionContents(DataComponentGetEvent.PotionContents event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        PotionContents itemStackPotionContents = (PotionContents)event.getOriginalValue();
        Optional potionColor = itemStackPotionContents.customColor();
        if (potionColor.isEmpty()) {
            return;
        }
        if ((Integer)potionColor.get() != 0x1FFF00) {
            return;
        }
        event.setValue(new PotionContents(itemStackPotionContents.potion(), Optional.empty(), itemStackPotionContents.customEffects(), itemStackPotionContents.customName()));
    }

    @SubscribeEvent
    public void onGetDyeColor(DataComponentGetEvent.DyedItemColor event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        DyedItemColor dyeColor = (DyedItemColor)event.getOriginalValue();
        if (dyeColor == null) {
            return;
        }
        if (dyeColor.rgb() != 0x1FFF00) {
            return;
        }
        event.setValue(null);
    }

    @SubscribeEvent
    public void onGetEnchantmentOverride(DataComponentGetEvent.EnchantmentGlintOverride event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        if (((Boolean)this.replaceGlint.get()).booleanValue()) {
            event.setValue(true);
        }
    }

    private boolean hasShinyStat(ItemStack itemStack) {
        Optional<ShinyItemProperty> shinyItemProperty = Models.Item.asWynnItemProperty(itemStack, ShinyItemProperty.class);
        return shinyItemProperty.isPresent() && shinyItemProperty.get().getShinyStat().isPresent();
    }
}

