/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.DataComponentGetEvent;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.game.MaterialItem;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.models.items.items.gui.StoreItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ItemHighlightFeature
extends Feature {
    private static final List<String> DEFAULT_HIGHLIGHT_KEYS = List.of("item_tier", "ingredient_tier", "material_tier", "store_tier");
    @Persisted
    private final Config<HighlightTexture> highlightTexture = new Config<HighlightTexture>(HighlightTexture.TAG);
    @Persisted
    private final Config<Boolean> normalHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> normalHighlightColor = new Config<CustomColor>(new CustomColor(255, 255, 255));
    @Persisted
    private final Config<Boolean> uniqueHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> uniqueHighlightColor = new Config<CustomColor>(new CustomColor(255, 255, 0));
    @Persisted
    private final Config<Boolean> rareHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> rareHighlightColor = new Config<CustomColor>(new CustomColor(255, 0, 255));
    @Persisted
    private final Config<Boolean> setHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> setHighlightColor = new Config<CustomColor>(new CustomColor(0, 255, 0));
    @Persisted
    private final Config<Boolean> legendaryHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> legendaryHighlightColor = new Config<CustomColor>(new CustomColor(0, 255, 255));
    @Persisted
    private final Config<Boolean> fabledHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> fabledHighlightColor = new Config<CustomColor>(new CustomColor(255, 85, 85));
    @Persisted
    private final Config<Boolean> mythicHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> mythicHighlightColor = new Config<CustomColor>(new CustomColor(76, 0, 76));
    @Persisted
    private final Config<Boolean> craftedHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> craftedHighlightColor = new Config<CustomColor>(new CustomColor(0, 138, 138));
    @Persisted
    private final Config<Boolean> zeroStarIngredientHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> zeroStarIngredientHighlightColor = new Config<CustomColor>(new CustomColor(102, 102, 102));
    @Persisted
    private final Config<Boolean> oneStarIngredientHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> oneStarIngredientHighlightColor = new Config<CustomColor>(new CustomColor(255, 247, 153));
    @Persisted
    private final Config<Boolean> twoStarIngredientHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> twoStarIngredientHighlightColor = new Config<CustomColor>(new CustomColor(255, 255, 0));
    @Persisted
    private final Config<Boolean> threeStarIngredientHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> threeStarIngredientHighlightColor = new Config<CustomColor>(new CustomColor(230, 77, 0));
    @Persisted
    private final Config<Boolean> oneStarMaterialHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> oneStarMaterialHighlightColor = new Config<CustomColor>(new CustomColor(255, 247, 153));
    @Persisted
    private final Config<Boolean> twoStarMaterialHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> twoStarMaterialHighlightColor = new Config<CustomColor>(new CustomColor(255, 255, 0));
    @Persisted
    private final Config<Boolean> threeStarMaterialHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> threeStarMaterialHighlightColor = new Config<CustomColor>(new CustomColor(230, 77, 0));
    @Persisted
    private final Config<Boolean> storeHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> powderHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> emeraldPouchHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> inventoryHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Float> inventoryOpacity = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Boolean> hotbarHighlightEnabled = new Config<Boolean>(true);
    @Persisted
    private final Config<Float> hotbarOpacity = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Boolean> selectedItemHighlight = new Config<Boolean>(true);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderSlot(SlotRenderEvent.CountPre e) {
        if (!((Boolean)this.inventoryHighlightEnabled.get()).booleanValue()) {
            return;
        }
        CustomColor color = this.getHighlightColor(e.getSlot().getItem(), false);
        if (color == CustomColor.NONE) {
            return;
        }
        if (((Boolean)this.selectedItemHighlight.get()).booleanValue() && McUtils.inventory().getSelected().equals(e.getSlot().getItem())) {
            RenderSystem.enableDepthTest();
            RenderUtils.drawTexturedRectWithColor(e.getPoseStack(), Texture.HOTBAR_SELECTED_HIGHLIGHT.resource(), color, e.getSlot().x, e.getSlot().y, 100.0f, 16.0f, 16.0f, 16, 16);
            RenderSystem.disableDepthTest();
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectWithColor(e.getPoseStack(), Texture.HIGHLIGHT.resource(), color, e.getSlot().x - 1, e.getSlot().y - 1, 100.0f, 18.0f, 18.0f, ((HighlightTexture)((Object)this.highlightTexture.get())).ordinal() * 18 + 18, 0, 18, 18, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onRenderHotbarSlot(HotbarSlotRenderEvent.Pre e) {
        if (!((Boolean)this.hotbarHighlightEnabled.get()).booleanValue()) {
            return;
        }
        CustomColor color = this.getHighlightColor(e.getItemStack(), true);
        if (color == CustomColor.NONE) {
            return;
        }
        if (((Boolean)this.selectedItemHighlight.get()).booleanValue() && McUtils.inventory().getSelected().equals(e.getItemStack())) {
            BufferedRenderUtils.drawTexturedRectWithColor(e.getPoseStack(), (MultiBufferSource)e.getGuiGraphics().bufferSource, Texture.HOTBAR_SELECTED_HIGHLIGHT, color, e.getX(), e.getY());
            return;
        }
        BufferedRenderUtils.drawTexturedRectWithColor(e.getPoseStack(), (MultiBufferSource)e.getGuiGraphics().bufferSource, Texture.HIGHLIGHT.resource(), color, e.getX() - 1, e.getY() - 1, 0.0f, 18.0f, 18.0f, ((HighlightTexture)((Object)this.highlightTexture.get())).ordinal() * 18 + 18, 0, 18, 18, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
    }

    @SubscribeEvent
    public void onGetModelData(DataComponentGetEvent.CustomModelData event) {
        CustomModelData itemStackModelData = (CustomModelData)event.getOriginalValue();
        List<String> newStrings = itemStackModelData.strings().stream().filter(s -> DEFAULT_HIGHLIGHT_KEYS.stream().noneMatch(s::startsWith)).toList();
        if (!newStrings.equals(itemStackModelData.strings())) {
            event.setValue(new CustomModelData(itemStackModelData.floats(), itemStackModelData.flags(), newStrings, itemStackModelData.colors()));
        }
    }

    private CustomColor getHighlightColor(ItemStack itemStack, boolean hotbarHighlight) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return CustomColor.NONE;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        HighlightInfo highlight = wynnItem.getData().getOrCalculate("highlight", () -> this.calculateHighlightInfo((WynnItem)wynnItemOpt.get()));
        if (highlight == null) {
            return CustomColor.NONE;
        }
        if (!highlight.isHighlightEnabled()) {
            return CustomColor.NONE;
        }
        return highlight.getHighlightColor().withAlpha((hotbarHighlight ? (Float)this.hotbarOpacity.get() : (Float)this.inventoryOpacity.get()).floatValue());
    }

    private HighlightInfo calculateHighlightInfo(WynnItem wynnItem) {
        if (wynnItem instanceof GearTierItemProperty) {
            GearTierItemProperty gearItem = (GearTierItemProperty)((Object)wynnItem);
            return new GearHighlight(gearItem);
        }
        if (wynnItem instanceof IngredientItem) {
            IngredientItem ingredientItem = (IngredientItem)wynnItem;
            return new IngredientHighlight(ingredientItem);
        }
        if (wynnItem instanceof MaterialItem) {
            MaterialItem materialItem = (MaterialItem)wynnItem;
            return new MaterialHighlight(materialItem);
        }
        if (wynnItem instanceof PowderItem) {
            PowderItem powderItem = (PowderItem)wynnItem;
            return new PowderHighlight(powderItem);
        }
        if (wynnItem instanceof StoreItem) {
            StoreItem storeItem = (StoreItem)wynnItem;
            return new StoreHighlight(storeItem);
        }
        if (wynnItem instanceof EmeraldPouchItem) {
            EmeraldPouchItem emeraldPouchItem = (EmeraldPouchItem)wynnItem;
            return new EmeraldPouchHighlight(emeraldPouchItem);
        }
        return null;
    }

    public static enum HighlightTexture {
        TAG,
        CIRCLE_TRANSPARENT,
        CIRCLE_OPAQUE,
        CIRCLE_OUTLINE_LARGE,
        CIRCLE_OUTLINE_SMALL,
        BOX_TRANSPARENT,
        BOX_OPAQUE,
        BOX_GRADIENT_1,
        BOX_GRADIENT_2;

    }

    private static interface HighlightInfo {
        public CustomColor getHighlightColor();

        public boolean isHighlightEnabled();
    }

    private final class GearHighlight
    implements HighlightInfo {
        private final GearTierItemProperty item;

        private GearHighlight(GearTierItemProperty item) {
            this.item = item;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isHighlightEnabled() {
            if (this.item.getGearTier() == null) return false;
            if ((switch (this.item.getGearTier()) {
                default -> throw new MatchException(null, null);
                case GearTier.NORMAL -> (Boolean)ItemHighlightFeature.this.normalHighlightEnabled.get();
                case GearTier.UNIQUE -> (Boolean)ItemHighlightFeature.this.uniqueHighlightEnabled.get();
                case GearTier.RARE -> (Boolean)ItemHighlightFeature.this.rareHighlightEnabled.get();
                case GearTier.SET -> (Boolean)ItemHighlightFeature.this.setHighlightEnabled.get();
                case GearTier.LEGENDARY -> (Boolean)ItemHighlightFeature.this.legendaryHighlightEnabled.get();
                case GearTier.FABLED -> (Boolean)ItemHighlightFeature.this.fabledHighlightEnabled.get();
                case GearTier.MYTHIC -> (Boolean)ItemHighlightFeature.this.mythicHighlightEnabled.get();
                case GearTier.CRAFTED -> (Boolean)ItemHighlightFeature.this.craftedHighlightEnabled.get();
            }) == false) return false;
            return true;
        }

        @Override
        public CustomColor getHighlightColor() {
            CustomColor customColor;
            if (this.item.getGearTier() == null) {
                customColor = CustomColor.NONE;
            } else {
                switch (this.item.getGearTier()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        customColor = (CustomColor)ItemHighlightFeature.this.normalHighlightColor.get();
                        break;
                    }
                    case UNIQUE: {
                        customColor = (CustomColor)ItemHighlightFeature.this.uniqueHighlightColor.get();
                        break;
                    }
                    case RARE: {
                        customColor = (CustomColor)ItemHighlightFeature.this.rareHighlightColor.get();
                        break;
                    }
                    case SET: {
                        customColor = (CustomColor)ItemHighlightFeature.this.setHighlightColor.get();
                        break;
                    }
                    case LEGENDARY: {
                        customColor = (CustomColor)ItemHighlightFeature.this.legendaryHighlightColor.get();
                        break;
                    }
                    case FABLED: {
                        customColor = (CustomColor)ItemHighlightFeature.this.fabledHighlightColor.get();
                        break;
                    }
                    case MYTHIC: {
                        customColor = (CustomColor)ItemHighlightFeature.this.mythicHighlightColor.get();
                        break;
                    }
                    case CRAFTED: {
                        customColor = (CustomColor)ItemHighlightFeature.this.craftedHighlightColor.get();
                    }
                }
            }
            return customColor;
        }
    }

    private final class IngredientHighlight
    implements HighlightInfo {
        private final IngredientItem item;

        private IngredientHighlight(IngredientItem item) {
            this.item = item;
        }

        @Override
        public CustomColor getHighlightColor() {
            return switch (this.item.getQualityTier()) {
                case 0 -> (CustomColor)ItemHighlightFeature.this.zeroStarIngredientHighlightColor.get();
                case 1 -> (CustomColor)ItemHighlightFeature.this.oneStarIngredientHighlightColor.get();
                case 2 -> (CustomColor)ItemHighlightFeature.this.twoStarIngredientHighlightColor.get();
                case 3 -> (CustomColor)ItemHighlightFeature.this.threeStarIngredientHighlightColor.get();
                default -> CustomColor.NONE;
            };
        }

        @Override
        public boolean isHighlightEnabled() {
            return switch (this.item.getQualityTier()) {
                case 0 -> (Boolean)ItemHighlightFeature.this.zeroStarIngredientHighlightEnabled.get();
                case 1 -> (Boolean)ItemHighlightFeature.this.oneStarIngredientHighlightEnabled.get();
                case 2 -> (Boolean)ItemHighlightFeature.this.twoStarIngredientHighlightEnabled.get();
                case 3 -> (Boolean)ItemHighlightFeature.this.threeStarIngredientHighlightEnabled.get();
                default -> false;
            };
        }
    }

    private final class MaterialHighlight
    implements HighlightInfo {
        private final MaterialItem item;

        private MaterialHighlight(MaterialItem item) {
            this.item = item;
        }

        @Override
        public CustomColor getHighlightColor() {
            return switch (this.item.getQualityTier()) {
                case 1 -> (CustomColor)ItemHighlightFeature.this.oneStarMaterialHighlightColor.get();
                case 2 -> (CustomColor)ItemHighlightFeature.this.twoStarMaterialHighlightColor.get();
                case 3 -> (CustomColor)ItemHighlightFeature.this.threeStarMaterialHighlightColor.get();
                default -> CustomColor.NONE;
            };
        }

        @Override
        public boolean isHighlightEnabled() {
            return switch (this.item.getQualityTier()) {
                case 1 -> (Boolean)ItemHighlightFeature.this.oneStarMaterialHighlightEnabled.get();
                case 2 -> (Boolean)ItemHighlightFeature.this.twoStarMaterialHighlightEnabled.get();
                case 3 -> (Boolean)ItemHighlightFeature.this.threeStarMaterialHighlightEnabled.get();
                default -> false;
            };
        }
    }

    private final class PowderHighlight
    implements HighlightInfo {
        private final PowderItem item;

        private PowderHighlight(PowderItem item) {
            this.item = item;
        }

        @Override
        public boolean isHighlightEnabled() {
            return (Boolean)ItemHighlightFeature.this.powderHighlightEnabled.get();
        }

        @Override
        public CustomColor getHighlightColor() {
            return this.item.getPowderProfile().element().getColor();
        }
    }

    private final class StoreHighlight
    implements HighlightInfo {
        private final StoreItem item;

        private StoreHighlight(StoreItem item) {
            this.item = item;
        }

        @Override
        public boolean isHighlightEnabled() {
            return (Boolean)ItemHighlightFeature.this.storeHighlightEnabled.get();
        }

        @Override
        public CustomColor getHighlightColor() {
            return this.item.getHighlightColor();
        }
    }

    private final class EmeraldPouchHighlight
    implements HighlightInfo {
        private EmeraldPouchHighlight(EmeraldPouchItem item) {
        }

        @Override
        public boolean isHighlightEnabled() {
            return (Boolean)ItemHighlightFeature.this.emeraldPouchHighlightEnabled.get();
        }

        @Override
        public CustomColor getHighlightColor() {
            return CustomColor.fromChatFormatting(ChatFormatting.GREEN);
        }
    }
}

