/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.map;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderTileLevelLastEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.MAP)
public class BeaconBeamFeature
extends Feature {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    @Persisted
    private final Config<CustomColor> waypointBeamColor = new Config<CustomColor>(CommonColors.RED);
    private static final int RAINBOW_CHANGE_RATE = 10;
    private CustomColor currentRainbowColor = CommonColors.RED;

    @SubscribeEvent
    public void onTick(TickEvent event) {
        int r = this.currentRainbowColor.r();
        int g = this.currentRainbowColor.g();
        int b = this.currentRainbowColor.b();
        if (r > 0 && b == 0) {
            r -= 10;
            g += 10;
        }
        if (g > 0 && r == 0) {
            g -= 10;
            b += 10;
        }
        if (b > 0 && g == 0) {
            r += 10;
            b -= 10;
        }
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        this.currentRainbowColor = new CustomColor(r, g, b, 255);
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderTileLevelLastEvent event) {
        List<MarkerInfo> markers = Models.Marker.getAllMarkers().toList();
        if (markers.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        for (MarkerInfo marker : markers) {
            int maxDistance;
            Vec3 camera = event.getCamera().getPosition();
            Location location = marker.location();
            double dx = (double)location.x - camera.x();
            double dy = (double)location.y - camera.y();
            double dz = (double)location.z - camera.z();
            double distance = MathUtils.magnitude(dx, dz);
            if (distance > (double)(maxDistance = (Integer)McUtils.options().renderDistance().get() * 16)) {
                double scale = (double)maxDistance / distance;
                dx *= scale;
                dz *= scale;
            }
            float alpha = 1.0f;
            if (distance <= 7.0) {
                alpha = MathUtils.clamp(MathUtils.map((float)distance, 2.0f, 7.0f, 0.0f, 1.0f), 0.0f, 1.0f);
            }
            poseStack.pushPose();
            poseStack.translate(dx, dy, dz);
            CustomColor color = marker.beaconColor() == CustomColor.NONE ? (CustomColor)this.waypointBeamColor.get() : marker.beaconColor();
            int colorInt = color == CommonColors.RAINBOW ? this.currentRainbowColor.withAlpha(alpha).asInt() : color.withAlpha(alpha).asInt();
            BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)BUFFER_SOURCE, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)event.getDeltaTracker().getGameTimeDeltaPartialTick(false), (float)1.0f, (long)McUtils.player().level().getGameTime(), (int)0, (int)1024, (int)colorInt, (float)0.166f, (float)0.33f);
            poseStack.popPose();
        }
        BUFFER_SOURCE.endLastBatch();
    }
}

