/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.map;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.RenderLevelEvent;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.services.map.pois.WaypointPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@ConfigCategory(value=Category.MAP)
public class WorldWaypointDistanceFeature
extends Feature {
    private static final MultiBufferSource.BufferSource BUFFER_SOURCE = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(256));
    private static final WaypointPoi DUMMY_WAYPOINT = new WaypointPoi(() -> null, "");
    @Persisted
    private final Config<Float> backgroundOpacity = new Config<Float>(Float.valueOf(0.2f));
    @Persisted
    private final Config<Float> scale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.NONE);
    @Persisted
    private final Config<Float> bottomBoundingDistance = new Config<Float>(Float.valueOf(100.0f));
    @Persisted
    private final Config<Float> topBoundingDistance = new Config<Float>(Float.valueOf(40.0f));
    @Persisted
    private final Config<Float> horizontalBoundingDistance = new Config<Float>(Float.valueOf(30.0f));
    @Persisted
    private final Config<Integer> maxWaypointTextDistance = new Config<Integer>(5000);
    @Persisted
    public final Config<Boolean> showAdditionalTextInWorld = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showAdditionalTextAbove = new Config<Boolean>(false);
    private final List<RenderedMarkerInfo> renderedMarkers = new ArrayList<RenderedMarkerInfo>();

    @SubscribeEvent
    public void onRenderLevelPost(RenderLevelEvent.Post event) {
        this.renderedMarkers.clear();
        List<MarkerInfo> markers = Models.Marker.getAllMarkers().toList();
        if (markers.isEmpty()) {
            return;
        }
        for (MarkerInfo marker : markers) {
            Location location = marker.location();
            Matrix4f projection = new Matrix4f((Matrix4fc)event.getProjectionMatrix());
            Camera camera = event.getCamera();
            Vec3 cameraPos = camera.getPosition();
            Vector3f xp = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f yp = new Vector3f(0.0f, 1.0f, 0.0f);
            Quaternionf xRotation = new Quaternionf().rotationAxis((float)Math.toRadians(camera.getXRot()), (Vector3fc)xp);
            Quaternionf yRotation = new Quaternionf().rotationAxis((float)Math.toRadians(camera.getYRot() + 180.0f), (Vector3fc)yp);
            projection.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)xRotation));
            projection.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)yRotation));
            float dx = (float)((double)location.x + 0.5 - cameraPos.x());
            float dy = (float)((double)location.y + 0.5 - cameraPos.y());
            float dz = (float)((double)location.z + 0.5 - cameraPos.z());
            if (location.y <= 0 || location.y > 255) {
                dy = 0.0f;
            }
            double squaredDistance = dx * dx + dy * dy + dz * dz;
            double distance = Math.sqrt(squaredDistance);
            int maxDistance = (Integer)McUtils.options().renderDistance().get() * 16;
            String distanceText = Math.round((float)distance) + "m";
            if (distance > (double)maxDistance) {
                double posScale = (double)maxDistance / distance;
                dx = (float)((double)dx * posScale);
                dz = (float)((double)dz * posScale);
            }
            this.renderedMarkers.add(new RenderedMarkerInfo(distance, distanceText, marker, this.worldToScreen(new Vector3f(dx, dy, dz), projection), marker.additionalText()));
        }
    }

    @SubscribeEvent
    public void onRenderGuiPost(RenderEvent.Post event) {
        for (RenderedMarkerInfo renderedMarker : this.renderedMarkers) {
            float displayPositionY;
            float displayPositionX;
            if ((Integer)this.maxWaypointTextDistance.get() != 0 && (double)((Integer)this.maxWaypointTextDistance.get()).intValue() < renderedMarker.distance) continue;
            Objects.requireNonNull(FontRenderer.getInstance().getFont());
            float backgroundHeight = 9.0f;
            Vec2 intersectPoint = this.getBoundingIntersectPoint(renderedMarker.screenCoordinates, event.getWindow());
            Texture icon = renderedMarker.markerInfo.texture();
            float[] color = renderedMarker.markerInfo.textureColor().asFloatArray();
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
            if (intersectPoint == null) {
                float backgroundWidth;
                displayPositionX = (float)renderedMarker.screenCoordinates.x;
                displayPositionY = (float)renderedMarker.screenCoordinates.y;
                RenderUtils.drawScalingTexturedRect(event.getPoseStack(), icon.resource(), displayPositionX - ((Float)this.scale.get()).floatValue() * (float)icon.width() / 2.0f, displayPositionY - ((Float)this.scale.get()).floatValue() * ((float)icon.height() + backgroundHeight / 2.0f + 3.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (float)icon.width(), ((Float)this.scale.get()).floatValue() * (float)icon.height(), icon.width(), icon.height());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!((Boolean)this.showAdditionalTextAbove.get()).booleanValue() && renderedMarker.additionalText != null) {
                    backgroundWidth = FontRenderer.getInstance().getFont().width(renderedMarker.additionalText);
                    RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 3.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                    FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.additionalText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                    displayPositionY += ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue();
                }
                backgroundWidth = FontRenderer.getInstance().getFont().width(renderedMarker.distanceText);
                RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 3.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.distanceText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight + 2.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                if (!((Boolean)this.showAdditionalTextAbove.get()).booleanValue() || renderedMarker.additionalText == null) continue;
                backgroundWidth = FontRenderer.getInstance().getFont().width(renderedMarker.additionalText);
                RenderUtils.drawRect(event.getPoseStack(), CommonColors.BLACK.withAlpha(((Float)this.backgroundOpacity.get()).floatValue()), displayPositionX - ((Float)this.scale.get()).floatValue() * (backgroundWidth / 2.0f + 2.0f), displayPositionY - ((Float)this.scale.get()).floatValue() * (backgroundHeight / 2.0f) - 35.0f * ((Float)this.scale.get()).floatValue(), 0.0f, ((Float)this.scale.get()).floatValue() * (backgroundWidth + 2.0f), ((Float)this.scale.get()).floatValue() * (backgroundHeight + 2.0f));
                FontRenderer.getInstance().renderAlignedTextInBox(event.getPoseStack(), StyledText.fromString(renderedMarker.additionalText), displayPositionX - ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionX + ((Float)this.scale.get()).floatValue() * backgroundWidth, displayPositionY - ((Float)this.scale.get()).floatValue() * backgroundHeight - 33.0f * ((Float)this.scale.get()).floatValue(), displayPositionY + ((Float)this.scale.get()).floatValue() * backgroundHeight - 33.0f * ((Float)this.scale.get()).floatValue(), 0.0f, renderedMarker.markerInfo.textColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, (TextShadow)this.textShadow.get(), ((Float)this.scale.get()).floatValue());
                continue;
            }
            displayPositionX = intersectPoint.x;
            displayPositionY = intersectPoint.y;
            double angle = Math.toDegrees(StrictMath.atan2(displayPositionY - (float)(event.getWindow().getGuiScaledHeight() / 2), displayPositionX - (float)(event.getWindow().getGuiScaledWidth() / 2))) + 90.0;
            float radius = (float)(icon.width() / 2) + 8.0f;
            float pointerOffsetX = radius * (float)StrictMath.cos((angle - 90.0) * 3.0 / 180.0);
            float pointerOffsetY = radius * (float)StrictMath.sin((angle - 90.0) * 3.0 / 180.0);
            float pointerDisplayPositionX = displayPositionX + pointerOffsetX;
            float pointerDisplayPositionY = displayPositionY + pointerOffsetY;
            RenderUtils.drawScalingTexturedRect(event.getPoseStack(), icon.resource(), displayPositionX - ((Float)this.scale.get()).floatValue() * (float)icon.width() / 2.0f + pointerOffsetX * (1.0f - ((Float)this.scale.get()).floatValue()), displayPositionY - ((Float)this.scale.get()).floatValue() * (float)icon.height() / 2.0f + pointerOffsetY * (1.0f - ((Float)this.scale.get()).floatValue()), 0.0f, ((Float)this.scale.get()).floatValue() * (float)icon.width(), ((Float)this.scale.get()).floatValue() * (float)icon.height(), icon.width(), icon.height());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(pointerDisplayPositionX, pointerDisplayPositionY, 0.0f);
            poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.toRadians(angle)));
            poseStack.translate(-pointerDisplayPositionX, -pointerDisplayPositionY, 0.0f);
            DUMMY_WAYPOINT.getPointerPoi().renderAt(poseStack, (MultiBufferSource)BUFFER_SOURCE, pointerDisplayPositionX, pointerDisplayPositionY, false, ((Float)this.scale.get()).floatValue(), 1.0f, 50.0f, true);
            BUFFER_SOURCE.endBatch();
            poseStack.popPose();
        }
    }

    private Vec3 worldToScreen(Vector3f delta, Matrix4f projection) {
        Vector4f clipCoords = new Vector4f(delta.x(), delta.y(), delta.z(), 1.0f);
        projection.transform(clipCoords);
        Vector3d ndc = new Vector3d((double)(clipCoords.x() / clipCoords.w()), (double)(clipCoords.y() / clipCoords.w()), (double)(clipCoords.z() / clipCoords.w()));
        Window window = McUtils.window();
        return new Vec3((double)((float)((ndc.x + 1.0) / 2.0) * (float)window.getGuiScaledWidth()), (double)((float)((1.0 - ndc.y) / 2.0) * (float)window.getGuiScaledHeight()), (double)((float)ndc.z));
    }

    private Vec2 getBoundingIntersectPoint(Vec3 position, Window window) {
        if (this.isInBound((Position)position, window)) {
            return null;
        }
        Vec3 centerPoint = new Vec3((double)(window.getGuiScaledWidth() / 2), (double)(window.getGuiScaledHeight() / 2), 0.0);
        float pointerScaleCorrection = (float)Texture.POINTER.height() / 2.0f * (1.0f - ((Float)this.scale.get()).floatValue());
        float minX = (float)(-(centerPoint.x - (double)((Float)this.horizontalBoundingDistance.get()).floatValue() + (double)pointerScaleCorrection));
        float maxX = (float)centerPoint.x - ((Float)this.horizontalBoundingDistance.get()).floatValue() + pointerScaleCorrection;
        float minY = (float)(-(centerPoint.y - (double)((Float)this.topBoundingDistance.get()).floatValue() + (double)pointerScaleCorrection));
        float maxY = (float)centerPoint.y - ((Float)this.bottomBoundingDistance.get()).floatValue() + pointerScaleCorrection;
        Vec3 centerRelativePosition = position.subtract(centerPoint);
        if (centerRelativePosition.z > 1.0) {
            centerRelativePosition = centerRelativePosition.multiply(-1.0, -1.0, 1.0);
        }
        double angle = StrictMath.atan2(centerRelativePosition.y, centerRelativePosition.x);
        double m = StrictMath.tan(angle);
        centerRelativePosition = centerRelativePosition.x > 0.0 ? new Vec3((double)maxX, (double)maxX * m, 0.0) : new Vec3((double)minX, (double)minX * m, 0.0);
        if (centerRelativePosition.y > (double)maxY) {
            centerRelativePosition = new Vec3((double)maxY / m, (double)maxY, 0.0);
        } else if (centerRelativePosition.y < (double)minY) {
            centerRelativePosition = new Vec3((double)minY / m, (double)minY, 0.0);
        }
        return new Vec2((float)(centerRelativePosition.x + centerPoint.x), (float)(centerRelativePosition.y + centerPoint.y));
    }

    private boolean isInBound(Position position, Window window) {
        return position.x() > 0.0 && position.x() < (double)window.getGuiScaledWidth() && position.y() > 0.0 && position.y() < (double)window.getGuiScaledHeight() && position.z() < 1.0;
    }

    @Override
    protected void onConfigUpdate(Config<?> unknownConfig) {
        Window window = McUtils.window();
        switch (unknownConfig.getFieldName()) {
            case "topBoundingDistance": 
            case "bottomBoundingDistance": {
                Config<?> config = unknownConfig;
                if (!(((Float)config.get()).floatValue() > (float)window.getGuiScaledHeight() * 0.4f)) break;
                config.setValue(Float.valueOf((float)window.getGuiScaledHeight() * 0.4f));
                break;
            }
            case "horizontalBoundingDistance": {
                Config<?> config = unknownConfig;
                if (!(((Float)config.get()).floatValue() > (float)window.getGuiScaledWidth() * 0.4f)) break;
                config.setValue(Float.valueOf((float)window.getGuiScaledWidth() * 0.4f));
            }
        }
    }

    private record RenderedMarkerInfo(double distance, String distanceText, MarkerInfo markerInfo, Vec3 screenCoordinates, String additionalText) {
    }
}

