/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TOOLTIPS)
public class ItemGuessFeature
extends Feature {
    @Persisted
    private final Config<Boolean> showGuessesPrice = new Config<Boolean>(true);

    @SubscribeEvent
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        Optional<GearBoxItem> gearBoxItemOpt = Models.Item.asWynnItem(event.getItemStack(), GearBoxItem.class);
        if (gearBoxItemOpt.isEmpty()) {
            return;
        }
        List<Component> tooltips = LoreUtils.appendTooltip(event.getItemStack(), event.getTooltips(), this.getTooltipAddon(gearBoxItemOpt.get()));
        event.setTooltips(tooltips);
    }

    private List<Component> getTooltipAddon(GearBoxItem gearBoxItem) {
        int level;
        ArrayList<Component> addon = new ArrayList<Component>();
        List<GearInfo> possibleGear = Models.Gear.getPossibleGears(gearBoxItem);
        GearTier gearTier = gearBoxItem.getGearTier();
        if (possibleGear.isEmpty()) {
            return addon;
        }
        addon.add((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"feature.wynntils.itemGuess.possibilities").withStyle(ChatFormatting.GRAY)));
        TreeMap<Integer, List> levelToItems = new TreeMap<Integer, List>();
        for (GearInfo gearInfo : possibleGear) {
            level = gearInfo != null ? gearInfo.requirements().level() : -1;
            MutableComponent itemDesc = Component.literal((String)gearInfo.name()).withStyle(gearTier.getChatFormatting());
            if (Services.Favorites.isFavorite(gearInfo.name())) {
                itemDesc.withStyle(ChatFormatting.UNDERLINE);
            }
            levelToItems.computeIfAbsent(level, i -> new ArrayList()).add(itemDesc);
        }
        for (Map.Entry entry : levelToItems.entrySet()) {
            level = (Integer)entry.getKey();
            List itemsForLevel = (List)entry.getValue();
            if (itemsForLevel.isEmpty()) {
                WynntilsMod.warn("No items for level " + level + " in gear box " + String.valueOf((Object)gearBoxItem.getGearTier()) + " " + String.valueOf(gearBoxItem.getLevelRange()) + "!");
                continue;
            }
            MutableComponent guesses = Component.literal((String)"    ");
            guesses.append((Component)Component.literal((String)"- ").withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"feature.wynntils.itemGuess.levelLine", (Object[])new Object[]{level == -1 ? "?" : Integer.valueOf(level)}).withStyle(ChatFormatting.GRAY)));
            if (((Boolean)this.showGuessesPrice.get()).booleanValue() && level != -1) {
                guesses.append((Component)Component.literal((String)" [").append((Component)Component.literal((String)(gearTier.getGearIdentificationCost(level) + " " + EmeraldUnits.EMERALD.getSymbol())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)"]")).withStyle(ChatFormatting.GRAY));
            }
            guesses.append((Component)StyledText.fromString("\u00a77: ").getComponent());
            MutableComponent itemsComponent = Component.empty();
            itemsComponent.append((Component)itemsForLevel.getFirst());
            itemsForLevel.stream().skip(1L).forEach(i -> itemsComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY)).append((Component)i));
            if (itemsForLevel.isEmpty()) continue;
            guesses.append((Component)itemsComponent);
            addon.add((Component)guesses);
        }
        return addon;
    }
}

